#! /bin/bash

function install_func {

apt-get update
apt-get install -y newt52

if (whiptail --title "cddisk" --yesno "Make clean install?" 10 60); then
    echo "Making clean install."
    apt-get -y remove cdmail
    apt-get -y remove calendar
    apt-get -y remove cddisk
    apt-get -y remove r7-office-documentserver
    apt-get -y remove postgresql*
    apt-get -y remove nginx
fi

apt-get install -y nginx

mkdir /etc/nginx/sites-enabled
mkdir /etc/nginx/sites-enabled.d
mkdir /etc/nginx/sites-available
mkdir /etc/nginx/sites-available.d

cat<<EOF >/etc/nginx/nginx.conf
worker_processes 1;
error_log /var/log/nginx/error.log warn;
pid /var/run/nginx.pid;
events {
worker_connections 1024;
}
http {
include /etc/nginx/mime.types;
default_type application/octet-stream;
log_format main '$$remote_addr - $$remote_user [$$time_local] "$$request" '
'$$status $$body_bytes_sent "$$http_referer" '
'"$$http_user_agent" "$$http_x_forwarded_for"';
access_log /var/log/nginx/access.log main;
sendfile on;
#tcp_nopush on;
keepalive_timeout 65;
#gzip on;
include /etc/nginx/sites-enabled/*;
include /etc/nginx/sites-enabled.d/*;
}
EOF

systemctl enable nginx
systemctl start nginx

DS_RABBITMQ_HOST=localhost;
DS_RABBITMQ_USER=guest;
DS_RABBITMQ_PWD=guest;

#sudo DEBIAN_FRONTEND=noninteractive apt-get -y install rabbitmq-server
if [ -f /var/tmp/r7mkpg ]; then
    sudo rm -f /var/tmp/r7mkpg
fi

if (whiptail --title "cddisk" --yesno "Install postgresql server on local pc?" 10 60); then
    echo "Install postgresql on local pc."
    apt-get install -y postgresql14-server
    /etc/init.d/postgresql initdb
    path_pg_hba=$(find /var/lib/pgsql/data -name pg_hba.conf)
    echo postgresql conf path is: $path_pg_hba
    sudo cat <<EOF >$path_pg_hba
# TYPE  DATABASE        USER            ADDRESS                 METHOD

# "local" is for Unix domain socket connections only
local   all             all                                     trust
# IPv4 local connections:
host    all             all             127.0.0.1/32            trust
# IPv6 local connections:
host    all             all             ::1/128                 trust
# Allow replication connections from localhost, by a user with the
# replication privilege.
local   replication     all                                     peer
host    replication     all             127.0.0.1/32            ident
host    replication     all             ::1/128                 ident
EOF
    sudo systemctl enable postgresql
    sudo systemctl stop postgresql
    sudo systemctl start postgresql
    sudo echo "" >> /var/tmp/r7mkpg
    DB_CREATE_POSTGRESQL="true"
    export DB_CREATE_POSTGRESQL="$DB_CREATE_POSTGRESQL"
    #sudo echo cddisk cddisk/db-create-postgresql select true | sudo debconf-set-selections
else
    echo "Install postgresql client on local pc."
    apt-get install -y postgresql
    DB_CREATE_POSTGRESQL="false"
    export DB_CREATE_POSTGRESQL="$DB_CREATE_POSTGRESQL"
fi

apt-get install -y rabbitmq-server supervisor redis expect java-17-openjdk
systemctl enable redis
systemctl start redis
systemctl enable rabbitmq
systemctl start rabbitmq
systemctl enable supervisord
systemctl start supervisord

rabbit_pass=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
rabbitmqctl add_user team $rabbit_pass
rabbitmqctl set_user_tags team administrator
rabbitmqctl set_permissions -p / team ".*" ".*" ".*"  

#sudo ./install_ds.sh

INSTALL_DS_LOCAL=""
if (whiptail --title "cddisk" --yesno "Install Document Server?" 10 60); then
    INSTALL_DS_LOCAL="true"
else
    INSTALL_DS_LOCAL="false"
fi

if [ "true" = "$INSTALL_DS_LOCAL" ]; then
    echo "Install Document Server."
    if [ -f /var/www/r7-office/documentserver/server/FileConverter/bin/docbuilder ]; then
    echo "Document server allready installed."
    else
    echo "Document server not installed."
    INSTALL_DS_LOCAL="true"
    if [ -f /var/tmp/r7mkpg ]; then
        sudo -i -u postgres psql -c "CREATE DATABASE ds;"
        sudo -i -u postgres psql -c "CREATE USER ds WITH password 'ds';"
        sudo -i -u postgres psql -c "GRANT ALL privileges ON DATABASE ds TO ds;"
        sudo -i -u postgres psql -c "ALTER DATABASE ds OWNER TO ds;"
        sudo rm /var/tmp/r7mkpg
    fi

    jwt_token=$(whiptail --title "cddisk" --ok-button "OK" --cancel-button "Cancel" --passwordbox "Enter Document Server secret" 10 60 "" 3>&1 1>&2 2>&3)
    if ! [ $? = 0 ] || [ -z "$jwt_token" ]; then
        jwt_token=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
        echo "Random secret generated."
    fi
    echo "Install Document Server."

    DS_DB_PWD=$(whiptail --title "Настраивается r7-office-documentserver-ee" --passwordbox  "Database password: " 10 60 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ] || [ -z "$DS_DB_PWD" ]; then
	echo "DS use default DB password."
	DS_DB_PWD="saSA123$"
    fi

    DS_REDIS_HOST=localhost;
    DS_COMMON_NAME=${DS_COMMON_NAME:-"ds"};
    DS_DB_HOST=localhost;
    DS_DB_NAME=$DS_COMMON_NAME;
    DS_DB_USER=$DS_COMMON_NAME;
    DS_DB_PWD=$DS_COMMON_NAME;
    export DS_PORT=8083
    export JWT_ENABLED=true;
    export JWT_HEADER="AuthorizationJwt";
    export DOCUMENT_URL="$EXTERNAL_DS_DOMAIN"
    export JWT_KEY="$jwt_token"
    export JWT_SECRET="$jwt_token"
    export DS_EXTERNAL="false"

    #echo CDDisk cddisk/jwt-key password $jwt_token | sudo debconf-set-selections
    #echo CDDisk cddisk/ds-external boolean false | sudo debconf-set-selections
    #sudo DEBIAN_FRONTEND=noninteractive apt-get -y install redis redis-server debconf adduser ca-certificates coreutils curl libasound2 libcairo2 libcurl4 libcurl3-gnutls libgconf-2-4 libgtk-3-0 libstdc++6 libxml2 libxss1 libxtst6 logrotate nginx-extras postgresql-client  pwgen redis-tools supervisor ttf-mscorefonts-installer xvfb zlib1g
    #sudo apt-get -y install ./r7-office-documentserver*.deb

    if ! su - postgres -s /bin/bash -c "psql -lqt" | cut -d \| -f 1 | grep -q ${DS_DB_NAME}; then
	su - postgres -s /bin/bash -c "psql -c \"CREATE DATABASE ${DS_DB_NAME};\""
	su - postgres -s /bin/bash -c "psql -c \"CREATE USER ${DS_DB_USER} WITH password '${DS_DB_PWD}';\""
	su - postgres -s /bin/bash -c "psql -c \"GRANT ALL privileges ON DATABASE ${DS_DB_NAME} TO ${DS_DB_USER};\""
    fi

    apt-get install -y ./r7-office-documentserver-ee-*.x86_64.rpm

    documentserver-configure.sh -dbh $DS_DB_HOST --databasename $DS_DB_NAME --databaseuser $DS_DB_USER --databasepassword $DS_DB_PWD --redishost $DS_REDIS_HOST --amqphost $DS_RABBITMQ_HOST --amqpuser $DS_RABBITMQ_USER --amqppassword $DS_RABBITMQ_PWD

    chmod 664 /etc/r7-office/documentserver/local.json
    fi
else
    EXTERNAL_DS_DOMAIN=$(whiptail --title  "cddisk" --inputbox  "Document Server URL:" 10 60 http://local.ru:8083 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "external DS URL: $EXTERNAL_DS_DOMAIN"
    else
	EXTERNAL_DS_DOMAIN = "local.ru"
        echo "external DS URL: $EXTERNAL_DS_DOMAIN"
    fi

    EXTERNAL_DS_JWT_KEY=$(whiptail --title  "cddisk" --inputbox  "Document Server JWT key:" 10 60 jwt-key 3>&1 1>&2 2>&3)
    exitstatus=$?
    if ! [ $exitstatus = 0 ] || [ -z "$EXTERNAL_DS_JWT_KEY" ]; then
        EXTERNAL_DS_JWT_KEY=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
        echo "Random secret generated."
    fi

    export DOCUMENT_URL="$EXTERNAL_DS_DOMAIN"
    export JWT_KEY="$EXTERNAL_DS_JWT_KEY"
    export DS_EXTERNAL="true"
fi

#sudo sed -i 's/\"savetimeoutdelay\":\ 5000/\"savetimeoutdelay\":\ 1000/g' /etc/r7-office/documentserver/default.json

if (whiptail --title "cddisk" --yesno "Install CDDisk api & web?" 10 60); then
    OPTION=$(whiptail --title  "Настраивается cddisk" --menu  "Choose database type" 12 40 4 "postgresql" "" "mssql" "" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "Your chosen db type:" $OPTION
    else
	OPTION="postgresql"
	echo "You chose Cancel, use db type:" $OPTION
    fi
    export DB_TYPE="$OPTION"
    
    if (whiptail --title "Настраивается cddisk" --yesno "Create database?" 10 60); then
	CREATE_DB_IN="true"
    else
	CREATE_DB_IN="false"
    fi
    export CREATE_DB="$CREATE_DB_IN"

    DB_HOST_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Database host: " 10 60 "localhost" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk db host: $DB_HOST_IN"
    else
	DB_HOST_IN = "localhost"
	echo "cddisk db host: $DB_HOST_IN"
    fi
    export DB_HOST="$DB_HOST_IN"

    DB_PORT_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Database port: " 10 60 "5432" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk db port: $DB_PORT_IN"
    else
	DB_PORT_IN = 5432
	echo "cddisk db port: $DB_PORT_IN"
    fi
    export DB_PORT="$DB_PORT_IN"

    DB_USER_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Database user for create DB: " 10 60 "cddisk" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk db user: $DB_USER_IN"
    else
	DB_USER_IN = "cddisk"
	echo "cddisk db user: $DB_USER_IN"
    fi
    export DB_USER="$DB_USER_IN"

    DB_PWD_IN=$(whiptail --title "Настраивается cddisk" --passwordbox  "Database for create DB password: " 10 60 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk db passwd: ********"
    else
	DB_PWD_IN = "saSA123$"
    fi
    export DB_PWD="$DB_PWD_IN"
    export DB_CREATE_PWD="$DB_PWD_IN"

    KEY_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "The salt to be used during the key derivation process: " 10 60 "Vskoproizvolny Salt par Chivreski" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk salt key: $KEY_IN"
    else
	KEY_IN = "Vskoproizvolny Salt par Chivreski"
	echo "cddisk salt key: $KEY_IN"
    fi
    export CORE_MACHINE_KEY="$KEY_IN"

    if (whiptail --title "Настраивается cddisk" --yesno "Make HTTPS?" 10 60); then
	echo "make HTTPS true"
	export MAKE_HTTPS="true";
    else
	echo "make HTTPS false"
	export MAKE_HTTPS="false";
    fi

    LOCAL_SITE_DOMAIN=$(whiptail --title  "Настраивается cddisk" --inputbox  "Domain name:" 10 60 "local.ru" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk site domain: $LOCAL_SITE_DOMAIN"
    else
	LOCAL_SITE_DOMAIN = "local.ru"
	echo "cddisk site domain: $LOCAL_SITE_DOMAIN"
    fi
    export SITE_DOMAIN="$LOCAL_SITE_DOMAIN"

    PREFIX_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name: " 10 60 "cddisk" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cddisk prefix name: $PREFIX_IN"
    else
	PREFIX_IN = "cddisk"
	echo "cddisk prefix name: $PREFIX_IN"
    fi
    export CDDISK_NAME="$PREFIX_IN"

    PREFIX_ADMIN_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for admin: " 10 60 "admin" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "admin prefix name: $PREFIX_ADMIN_IN"
    else
	PREFIX_ADMIN_IN = "admin"
	echo "admin prefix name: $PREFIX_ADMIN_IN"
    fi
    export ADMIN_NAME="$PREFIX_ADMIN_IN"

    PREFIX_CONTACTS_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for contacts: " 10 60 "contacts" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "contacts prefix name: $PREFIX_CONTACTS_IN"
    else
	PREFIX_CONTACTS_IN = "contacts"
	echo "contacts prefix name: $PREFIX_CONTACTS_IN"
    fi
    export CONTACTS_NAME="$PREFIX_CONTACTS_IN"

    PREFIX_PROJECTS_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for projects: " 10 60 "projects" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "projects prefix name: $PREFIX_PROJECTS_IN"
    else
	PREFIX_PROJECTS_IN = "projects"
	echo "projects prefix name: $PREFIX_PROJECTS_IN"
    fi
    export PROJECTS_NAME="$PREFIX_PROJECTS_IN"

    PREFIX_PAGES_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for pages: " 10 60 "pages" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "pages prefix name: $PREFIX_PAGES_IN"
    else
	PREFIX_PAGES_IN = "pages"
	echo "pages prefix name: $PREFIX_PAGES_IN"
    fi
    export PAGES_NAME="$PREFIX_PAGES_IN"

    PREFIX_FORMS_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for forms: " 10 60 "forms" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "forms prefix name: $PREFIX_FORMS_IN"
    else
	PREFIX_FORMS_IN = "forms"
	echo "forms prefix name: $PREFIX_FORMS_IN"
    fi
    export FORMS_NAME="$PREFIX_FORMS_IN"

    export RABBITMQ_TEAM_PASS="$rabbit_pass"

    PREFIX_CDMAIL_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for cdmail: " 10 60 "cdmail" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "cdmail prefix name: $PREFIX_CDMAIL_IN"
    else
	PREFIX_CDMAIL_IN = "cdmail"
	echo "cdmail prefix name: $PREFIX_CDMAIL_IN"
    fi
    export PREFIX_CDMAIL="$PREFIX_CDMAIL_IN"
    export CDMAIL_NAME="$PREFIX_CDMAIL_IN"

    PREFIX_CALENDAR_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for calendar: " 10 60 "calendar" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "calendar prefix name: $PREFIX_CALENDAR_IN"
    else
	PREFIX_CALENDAR_IN = "calendar"
	echo "calendar prefix name: $PREFIX_CALENDAR_IN"
    fi
    export PREFIX_CALENDAR="$PREFIX_CALENDAR_IN"
    export CALENDAR_NAME="$PREFIX_CALENDAR_IN"

    PREFIX_DS_NAME_IN=$(whiptail --title "Настраивается cddisk" --inputbox  "Prefix name for ds: " 10 60 "ds" 3>&1 1>&2 2>&3)
    exitstatus=$?
    if [ $exitstatus = 0 ];  then
	echo "ds prefix name: $PREFIX_DS_NAME_IN"
    else
	PREFIX_DS_NAME_IN = "ds"
	echo "ds prefix name: $PREFIX_DS_NAME_IN"
    fi
    export DS_NAME="$PREFIX_DS_NAME_IN"

    if [ $MAKE_HTTPS = "true" ]; then
        if ! [ -f ./../sslcert/$LOCAL_SITE_DOMAIN.crt ] || ! [ -f ./../sslcert/$LOCAL_SITE_DOMAIN.key ]; then
	whiptail --title "cddisk" --msgbox "Certificates not found in sslcert dir. Exit installation..." 10 60
	sudo rm -r /var/tmp/sslcert
	echo "failed" > /var/tmp/error
	return 120
        fi
    fi

    apt-get install -y curl

    sudo rm -r /var/tmp/sslcert
    sudo rm /var/tmp/error
    cp -r ./../sslcert/ /var/tmp/

    export DOMAIN="$LOCAL_SITE_DOMAIN"

    cp /bin/sed /usr/bin/sed

    apt-get install -y ./cddisk-*.x86_64.rpm
    sudo systemctl daemon-reload
    sudo systemctl enable java-maker
    sudo systemctl start java-maker
    apt-get install -y ./calendar-*.x86_64.rpm
    apt-get install -y ./cdmail-*.x86_64.rpm

#    INSTALL_DRAW_LOCAL=""
#    if (whiptail --title "Настраивается cddisk" --yesno "Setup R7 Draw?" 10 60); then
#	INSTALL_DRAW_LOCAL="true"
#    else
#	INSTALL_DRAW_LOCAL="false"
#    fi
#
#    if [ "true" = "$INSTALL_DRAW_LOCAL" ]; then
#	echo "Setup R7 Draw."
#
#	if [ "$MAKE_HTTPS" = "true" ]; then
#	    API_URL_ext="https://$PREFIX_IN.$LOCAL_SITE_DOMAIN"
#	else
#	    API_URL_ext="http://$PREFIX_IN.$LOCAL_SITE_DOMAIN"
#	fi
#	echo "R7 DRAW API_URL: $API_URL_ext"
#
#	export API_URL="$API_URL_ext"
#	dnf install -y ./r7draw-*.x86_64.rpm
#    fi

    if [ -f /var/tmp/error ]; then
        sudo rm -r /var/tmp/sslcert
        sudo rm /var/tmp/error
        whiptail --title "cddisk" --msgbox "Certificates not found in sslcert dir. HTTPS support disabled." 10 60
    fi
    if [ -f /var/tmp/r7mkpg ]; then
        sudo rm /var/tmp/r7mkpg
    fi

    #MAKEHTTPS=$(debconf-show cddisk | grep make-https | cut -d ':' -f 2 | tr -d ' ')
    echo "MAKE_HTTPS=$MAKE_HTTPS"
    if [ "$MAKE_HTTPS" = "true" ] && [ -d /var/tmp/sslcert/ ]; then
        echo "Making after HTTPS install"
        mkdir -p /var/www/r7-office/Data/ssl
        cp -f ./ds.conf /etc/r7-office/documentserver/nginx/ds.conf
        SECRET=$(cat /etc/r7-office/documentserver/local.json | grep secretString | sed 's/\"//g' | cut -d ':' -f 2 | tr -d ' ')
        cp /var/tmp/sslcert/$DOMAIN.crt /var/www/r7-office/Data/ssl/$DOMAIN.crt
        cp /var/tmp/sslcert/$DOMAIN.key /var/www/r7-office/Data/ssl/$DOMAIN.key
        sed -i "s#server_name ds.devr7.ru;#server_name $DS_NAME.$DOMAIN;#g" /etc/r7-office/documentserver/nginx/ds.conf
        sed -i "s#ssl_certificate /etc/nginx/ssl/devr7.ru.crt;#ssl_certificate /var/www/r7-office/Data/ssl/$DOMAIN.crt;#g" /etc/r7-office/documentserver/nginx/ds.conf
        sed -i "s#ssl_certificate_key /etc/nginx/ssl/devr7.ru.key;#ssl_certificate_key /var/www/r7-office/Data/ssl/$DOMAIN.key;#g" /etc/r7-office/documentserver/nginx/ds.conf
	sed -i "s#set \$secure_link_secret Vrd68RbCZG99DaO6xSSd;#set \$secure_link_secret $SECRET;#g" /etc/r7-office/documentserver/nginx/ds.conf
        systemctl nginx restart
        bash /usr/bin/documentserver-update-securelink.sh
        bash /usr/bin/documentserver-generate-allfonts.sh
        sudo rm -r /var/tmp/sslcert
    fi

    sed -i "/SELINUX=enforcing/d" /etc/selinux/config
    sed -i "/SELINUX=permissive/d" /etc/selinux/config
    echo "SELINUX=disabled" >> /etc/selinux/config
fi

sudo supervisorctl restart cddisk:*

echo "CDDisk setup complete."

chmod +r /opt/r7-office/installtools
chmod +r /opt/r7-office/installtools/json

cp -f r7-healthcheck.sh /opt/r7-office/r7-healthcheck.sh
chmod +x /opt/r7-office/r7-healthcheck.sh
chown root:root /opt/r7-office/r7-healthcheck.sh

cp -f r7-logcheck.sh /opt/r7-office/r7-logcheck.sh
chmod +x /opt/r7-office/r7-logcheck.sh
chown root:root /opt/r7-office/r7-logcheck.sh

cat<<EOF >/etc/xdg/autostart/r7-healcheck.desktop
[Desktop Entry]
Type=Application
Exec=mate-terminal -e "/opt/r7-office/r7-healthcheck.sh"
Hidden=false
NoDisplay=false
X-MATE-Autostart-enabled=true
Name[en_US]=Healthcheck Script
Name=Healthcheck Script
Comment[en_US]=Run healthcheck script after login
Comment=Run healthcheck script after login
EOF

# Приветственное сообщение
echo -e "\nУстановка прошла успешно, чтобы получить доступ откройте в браузере:"
echo "Логин и пароль администратора superadmin superadmin"
if [ "$MAKE_HTTPS" = "true" ]; then
echo "Админ: https://$ADMIN_NAME.$DOMAIN"
echo "Диск: https://$CDDISK_NAME.$DOMAIN"
echo "Контакты: https://$PREFIX_CONTACTS.$DOMAIN"
echo "Календарь: https://$PREFIX_CALENDAR.$DOMAIN"
echo "Почта: https://$PREFIX_CDMAIL.$DOMAIN"
echo "Проекты: https://$PREFIX_PROJECTS.$DOMAIN"
else
echo "Админ: http://$ADMIN_NAME.$DOMAIN"
echo "Диск: http://$CDDISK_NAME.$DOMAIN"
echo "Контакты: http://$PREFIX_CONTACTS.$DOMAIN"
echo "Календарь: http://$PREFIX_CALENDAR.$DOMAIN"
echo "Почта: http://$PREFIX_CDMAIL.$DOMAIN"
echo "Проекты: http://$PREFIX_PROJECTS.$DOMAIN"
fi
echo ""
echo ""
echo "Для завершения установки требуется перезагрузка"
echo ""
echo ""
echo "Для проверки работоспособности запустите /opt/r7-office/r7-healthcheck.sh после перезагрузки"

}

install_func 2>&1 | tee -a logfile.txt
sed -i "/cddisk db passwd:/d" logfile.txt
