DECLARE @TempMessageSettings Table ([Key] nvarchar(128), [Value] nvarchar(max), [Lang] nvarchar(12))

INSERT INTO @TempMessageSettings ([Key],  [Value], [Lang])
VALUES(
'apiUrl' ,'$(API_URL)','')

INSERT INTO @TempMessageSettings ([Key],  [Value], [Lang])
VALUES(
'siteUrl' ,'$(SITE_URL)','')

INSERT INTO @TempMessageSettings ([Key],  [Value], [Lang])
VALUES(
'documentServerUrl' ,'$(DOCUMENT_URL)','')

INSERT INTO @TempMessageSettings ([Key],  [Value], [Lang])
VALUES(
'domain' ,'$(DOMAIN)','')

INSERT INTO [MessageSettings]([Key], [Value], [Lang])
SELECT t.[Key], t.[Value], t.[Lang]
FROM @TempMessageSettings t
WHERE NOT EXISTS( SELECT [Id] FROM [dbo].[MessageSettings] m WITH(NOLOCK) WHERE m.[Key] = t.[Key])


INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'Can.Register' ,N'Can.Register',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'Can.Register');


--- Предоставлен доступ к файлу
INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFile|Subject' ,N'Документы. Предоставлен доступ к файлу {0}',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFile|Subject');


---EMAIL Templates
-- Новая почта
INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'NewEmail|BodyHtml' ,N'Please click on the <a href="{0}">link </a> if you want to add a new mail ',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'NewEmail|BodyHtml');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'NewEmail|BodyText' ,N'Please click on the <a href="{0}">link </a> if you want to add a new mail ',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'NewEmail|BodyText');

--- Сброс пароля
INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ResetPasswordEmail|Subject' ,N'Reset Password Message',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ResetPasswordEmail|Subject');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ResetPasswordEmail|BodyHtml' ,N'Please click on the <a href="{0}">link {1}</a> if you want to reset password:{2}',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ResetPasswordEmail|BodyHtml');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ResetPasswordEmail|BodyText' ,N'Please click on the <a href="{0}">link {1}</a> if you want to reset password:{2}',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ResetPasswordEmail|BodyText');

--- Предоставлен доступ к папке
INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFolder|Subject' ,N'Документы. Предоставлен доступ к папке {0}',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFolder|Subject');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFolder|BodyHtml' ,N'Предоставлен доступ к папке: <a href="{1}">{0}</a> {2} Пользователь {3} предоставил Вам доступ к папке <a href="{1}">{0}</a> с правами доступа: "{4}"',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFolder|BodyHtml');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFolder|BodyText' ,N'Предоставлен доступ к папке: <a href="{1}">{0}</a> {2} Пользователь {3} предоставил Вам доступ к папке <a href="{1}">{0}</a> с правами доступа: "{4}"',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFolder|BodyText');

--- Предоставлен доступ к файлу
INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFile|Subject' ,N'Документы. Предоставлен доступ к файлу {0}',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFile|Subject');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFile|BodyHtml' ,N'Предоставлен доступ к папке: <a href="{1}">{0}</a> {2} Пользователь {3} предоставил Вам доступ к файлу <a href="{1}">{0}</a> с правами доступа: "{4}"',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFile|BodyHtml');

INSERT INTO [dbo].[MessageSettings]([Key],  [Value], [Lang])
SELECT
'ShareFile|BodyText' ,N'Предоставлен доступ к папке: <a href="{1}">{0}</a> {2} Пользователь {3} предоставил Вам доступ к файлу <a href="{1}">{0}</a> с правами доступа: "{4}"',''
WHERE NOT EXISTS(SELECT [Id] FROM [dbo].[MessageSettings] AS m WHERE m.[Key] = N'ShareFile|BodyText');

