DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;

        BEGIN
           CREATE TABLE public."Address"
( 
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"TypeId" int NOT NULL,
	"Level" int NOT NULL,
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_Address_ObjectId"
    ON public."Address" USING btree
    ("ObjectId" ASC NULLS LAST, "Name" ASC NULLS LAST, "TypeId" ASC NULLS LAST, "Level" ASC NULLS LAST)
    TABLESPACE pg_default;
	

CREATE TABLE public."AddressTypes"
(
	"Id" BIGINT NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"ShortName" character varying(64) NOT NULL,
	PRIMARY KEY("Id")
);


CREATE TABLE public."Apartments"
(
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"TypeId" int NOT NULL,
	"Level" int,
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);


CREATE TABLE public."ApartmentTypes"
(
	"Id" bigint NOT NULL,
	"Name" character varying(64) NOT NULL,
	"ShortName" character varying(64) NOT NULL,
	PRIMARY KEY ("Id")
);


CREATE TABLE public."Carplaces"
(
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);


CREATE TABLE public."Houses"
(
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"TypeId" int NOT NULL,
	"PostIndex" character varying(100),
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_Houses_ObjectId"
    ON public."Houses" USING btree
    ("ObjectId" ASC NULLS LAST)
    TABLESPACE pg_default;
	
	
CREATE TABLE public."HouseTypes"
(
	"Id" bigint NOT NULL,
	"Name" character varying(64) NOT NULL,
	"ShortName" character varying(64) NOT NULL,
	PRIMARY KEY ("Id")
);

CREATE TABLE public."Relations"
(
	"Id" bigserial NOT NULL,
	"ObjectId" bigint NOT NULL,
	"ParentId" bigint NOT NULL,
	"ObjectType" int NOT NULL,
	PRIMARY KEY ("ParentId","ObjectId")
);

CREATE INDEX "IDX_Relations_ObjectId"
    ON public."Relations" USING btree
    ("ObjectId" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE TABLE public."Rooms"
(
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"TypeId" int NOT NULL,
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);


CREATE TABLE public."RoomTypes"
(
	"Id" bigint NOT NULL,
	"Name" character varying(64) NOT NULL,
	"ShortName" character varying(64) NOT NULL,
	PRIMARY KEY("Id")
);


CREATE TABLE public."Steads"
(
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
	PRIMARY KEY("Id")
);
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Create table <Address>.';
        END;
    END;
$$

