DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2440) THEN
		RETURN;
          END IF;
        BEGIN

      ALTER TABLE public."Contacts" ADD "City" character varying(500);
      ALTER TABLE public."Contacts" ADD "Company" character varying(2000);
      ALTER TABLE public."Contacts" ADD "Department" character varying(2000);
  
 CREATE INDEX "ix_Contacts_Login"
    ON public."Contacts" USING btree
    ("Login" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "ix_Contacts_Email"
    ON public."Contacts" USING btree
    ("Email" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Alter City,Company,Department table <Contacts> error.';
        END;
    END;
$$

