DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2772) THEN
		RETURN;
          END IF;
        BEGIN

       	 
CREATE TABLE IF NOT EXISTS public."ProjectLabels"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(500),
    "Color" character varying(64)  NOT NULL,
    "ProjectId" bigint NOT NULL,
    "OwnerId" bigint NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectLabels_pkey" PRIMARY KEY ("Id")
);
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectLabels-OwnerId"
    ON public."ProjectLabels" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX IF NOT EXISTS "IDX_ProjectLabels-ProjectId"
    ON public."ProjectLabels" USING btree
    ("ProjectId" ASC NULLS LAST)
    TABLESPACE pg_default;

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Create table ProjectLabels error.';
        END;
    END;
$$
