DO $$
	DECLARE 
	 path character varying(256) =  'Patch-2024-04-18-Create-LdapSyncSchedule';
	BEGIN

	IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=path) THEN
    		RETURN;
    	END IF;

 
	IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3780) THEN
		RETURN;
	END IF;

		CREATE TABLE public."LdapSyncSchedule" (
	"Id" bigserial NOT NULL,
	"CustomerId" integer NOT NULL,
	"LastDate" timestamp without time zone NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
	CONSTRAINT "PK_LdapSyncSchedule" PRIMARY KEY ("Id"),
	CONSTRAINT "UIDX_LdapSyncSchedule" UNIQUE ("CustomerId")
); 
	INSERT INTO public."Versions" ("Path", "Build")
      select path,0 ;

		EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE 'Create table LdapSyncSchedule error.';
		END;
$$
