DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-05-20-EventEmailInvite';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4102) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."EventEmailInvite" ADD "CalDavBody" VARCHAR NULL;
			ALTER TABLE public."EventDetails" ADD "SourceType" int2 NULL;

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-05-20-EventEmailInvite: %', SQLERRM;
		END;
	END;
$$
