DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-05-27-ProjectStatuses';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3846) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."ProjectStatuses" ADD "Order" BIGINT NULL;

			UPDATE public."ProjectStatuses" SET "Order"="Id";
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-05-27-ProjectStatuses: %', SQLERRM;
		END;
	END;
$$


