DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-06-04-ProjectsStartDate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3921) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."Projects" ADD  "StartDate" timestamp without time zone;
			ALTER TABLE public."Projects" ADD  "EndDate" timestamp without time zone;

			CREATE INDEX IF NOT EXISTS "IDX_ProjectTasks-Id-ProjectId"
    				ON public."ProjectTasks" USING btree
    				("Id"ASC NULLS LAST,"ProjectId"ASC NULLS LAST)
   				 TABLESPACE pg_default; 
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-05-27-ProjectsStartDate: %', SQLERRM;
		END;
	END;
$$


