DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-07-01-EventDetails_IsFree';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4444) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."EventDetails" ADD "IsFree" int4 NULL;
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-07-01-EventDetails_IsFree: %', SQLERRM;
		END;
	END;
$$