DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-12-13-ContactsIndexPhone';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14552) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE INDEX "ix_ContactsPhoneNumberEmailJid"
    ON public."Contacts" USING btree
    ("PhoneNumber" COLLATE pg_catalog."default" ASC NULLS LAST,"Email" COLLATE pg_catalog."default" ASC NULLS LAST,"Jid" COLLATE pg_catalog."default" ASC NULLS LAST) TABLESPACE pg_default; 
 
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-12-13-ContactsIndexPhone: %', SQLERRM;
		END;
	END;
$$ 