DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-12-16-UserContactId-Login';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14552) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE INDEX "IDX_Users_ContactId-Login"
				ON public."Users" USING btree
				("ContactId" ASC NULLS LAST,"Login" ASC NULLS LAST)
				TABLESPACE pg_default; 
 
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-12-16-UserContactId-Login: %', SQLERRM;
		END;
	END;
$$ 