
DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-08-14-MessageSettings_Admin_ModuleUrlData';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14243) THEN
			RETURN;
		END IF;

		BEGIN
			UPDATE public."MessageSettings" SET "Value" = '{"Icon":"/source/modules/icon-admin.svg", "Culture":{"ru":"Управление","en":"Management" }}' WHERE "Key" = 'Admin|ModuleUrlData';
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-08-14-MessageSettings_Admin_ModuleUrlData: %', SQLERRM;
		END;
	END;
$$