DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-10-14-UserAccessRights_UserIndex';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14342) THEN
			RETURN;
		END IF;

		BEGIN
            		CREATE INDEX "IDX_UserAccessRights_UserId-EntityId-EntityType"
    				ON public."UserAccessRights" USING btree
    				("UserId" ASC NULLS LAST, "EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST)
    				TABLESPACE pg_default; 

			CREATE INDEX "IDX_RoleAccessRights_RoleId-EntityId-EntityType"
    				ON public."RoleAccessRights" USING btree
    				("RoleId" ASC NULLS LAST,"EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST)
    				TABLESPACE pg_default; 

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-10-14-UserAccessRights_UserIndex: %', SQLERRM;
		END;
	END;
$$