DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-10-20-Documents_Size';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14390) THEN
			RETURN;
		END IF;

		BEGIN 
			ALTER TABLE public."Documents"  ADD "Size" bigint DEFAULT 0;
			UPDATE public."Documents" SET "Size"= (SELECT SUM(f."Size") FROM public."Files" f WHERE f."Id" IN(SELECT v."FileId" FROM 					public."DocumentVersions" v WHERE v."DocumentId"=public."Documents"."Id"));

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-10-20-Documents_Size: %', SQLERRM;
		END;
	END;
$$ 