DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_05_18-UserActionTypeDescriptions';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14984) THEN
			RETURN;
		END IF;

		BEGIN

			CREATE TABLE public."UserActionTypeDescriptions" (
				"Id" bigserial,
				"TypeCode" character varying(500),
				"System" character varying(500), 
				"Culture" character varying(20),
				"Name" character varying(500),
				"Level" int,
				PRIMARY KEY ("TypeCode", "Culture")
			);

			CREATE INDEX "IDX_UserActionTypeDescriptions_TypeCode_Culture"
				ON public."UserActionTypeDescriptions" USING btree
				("TypeCode" ASC NULLS LAST, "Culture" ASC NULLS LAST)
				TABLESPACE pg_default;

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
		EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_05_18-UserActionTypeDescriptions: %', SQLERRM;


		END;
	END;
$$