DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_12-FlexibleTables';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15113) THEN
			RETURN;
		END IF;

		BEGIN
            		


CREATE TABLE IF NOT EXISTS public."FlexibleTables"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(1000) NOT NULL,
    "CustomerId" integer NOT NULL,
    "Description" text,
    "OwnerId" bigint NOT NULL,
    "Type" integer NOT NULL DEFAULT 0,
    "Status" integer NOT NULL DEFAULT 1,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "FlexibleTables_pkey" PRIMARY KEY ("Name", "CustomerId")
);

CREATE INDEX IF NOT EXISTS "IDX_FlexibleTables-OwnerId-Id"
    ON public."FlexibleTables" USING btree
    ("OwnerId" ASC NULLS LAST,"Id" ASC NULLS LAST)
    TABLESPACE pg_default;

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_06_12-FlexibleTables: %', SQLERRM;
		END;
	END;
$$
