DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_12-ProjectFlexibleTables';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15113) THEN
			RETURN;
		END IF;

		BEGIN
            		

CREATE TABLE IF NOT EXISTS public."ProjectFlexibleTables"
(
    "Id" bigserial NOT NULL,
    "ProjectId" bigint NOT NULL,
    "FlexibleTableId" bigint NOT NULL,
    "AccessType" integer NOT NULL DEFAULT 0,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectFlexibleTables_pkey" PRIMARY KEY ("ProjectId", "FlexibleTableId")
);


 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_06_12-ProjectFlexibleTables: %', SQLERRM;
		END;
	END;
$$
