DO $$
declare 
roleId bigint := 3; 
appId int := 0;
BEGIN
    SELECT "Id" INTO roleId FROM public."Roles" where "CustomerId" = 1 AND "Type"=4;

    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'admin';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);

    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'mail';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);

    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'calendar';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);
    
    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'draw';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);

    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'contacts';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);
	
    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'pages';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);
	
    SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'forms';
    INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
    SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);

    IF EXISTS(SELECT "Key" FROM public."MessageSettings" WHERE "Key"='enableProjects' AND "Value"='1') THEN
        SELECT "Id" INTO appId FROM public."Applications" WHERE "Key" = 'projects';
        INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
        SELECT roleId, appId, 16, 512, 0 WHERE NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" WHERE "RoleId" = roleId AND "EntityId" = appId);
    END IF;
END $$;