CREATE TABLE public."Address"
( 
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"TypeId" int NOT NULL,
	"Level" int NOT NULL,
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_Address_ObjectId"
    ON public."Address" USING btree
    ("ObjectId" ASC NULLS LAST, "Name" ASC NULLS LAST, "TypeId" ASC NULLS LAST, "Level" ASC NULLS LAST)
    TABLESPACE pg_default;