CREATE TABLE public."Contacts" (
    "Id" bigserial Primary key,
    "Login" character varying(512) NOT NULL,
    "Jid" character varying(255) NOT NULL,
    "Type" integer NOT NULL,
    "FullName" character varying(255) NOT NULL,
    "Surname" character varying(255),
    "FirstName" character varying(255),
    "MiddleName" character varying(255),
    "Email" character varying(255),
    "IsConfirmed" boolean DEFAULT false NOT NULL,
    "BirthDate" date,
    "ImageId" bigint,
    "Notes" character varying(2048),
    "City" character varying(500),
    "Company" character varying(2000),
    "Department" character varying(2000),  
    "ArchivedDate" timestamp without time zone,
    "State" integer DEFAULT 0 NOT NULL,
    "ExternalId" character varying(2048),
    "PhoneNumber" character varying(25),
    "ImportedByUserId" bigint,
    "AddressId" bigint,
    "Address" character varying(1024),
    "Json" character varying
);

CREATE INDEX "Contacts_IDX_ContactsName"
    ON public."Contacts" USING btree
    ("Login" COLLATE pg_catalog."default" ASC NULLS LAST, "FullName" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE INDEX "ix_Contacts_ExternalId"
    ON public."Contacts" USING btree
    ("ExternalId" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "ix_Contacts_Login"
    ON public."Contacts" USING btree
    ("Login" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "ix_Contacts_Email"
    ON public."Contacts" USING btree
    ("Email" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "ix_ContactsPhoneNumberEmailJid"
    ON public."Contacts" USING btree
    ("PhoneNumber" COLLATE pg_catalog."default" ASC NULLS LAST,"Email" COLLATE pg_catalog."default" ASC NULLS LAST,"Jid" COLLATE pg_catalog."default" ASC NULLS LAST) TABLESPACE pg_default; 