CREATE TABLE public."Customers" (
    "Id" serial PRIMARY KEY,
    "Status" smallint NOT NULL,
    "Title" character varying NOT NULL,
    "Company" character varying,
    "Description" character varying,
    "CreatedAt" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "ParentId" BIGINT NULL,
    "AuthType" INT NULL,
    "IsParentSettings" BOOL DEFAULT(false) NOT NULL,
    "OwnerId" BIGINT NULL,
    "Alias" character varying(512) NULL,
    "Domain" character varying(512) NULL,
    "IsRoot" BOOL DEFAULT(false) NOT NULL,
    "RealmId" UUID NULL
);

CREATE INDEX "ix_Customers_Alias"
    ON public."Customers" USING btree
    ("Alias" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 