CREATE TABLE public."UserAccessRights" (
    "Id" bigserial NOT NULL,
    "UserId" bigint NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "OwnerId" bigint,
    PRIMARY KEY ("UserId", "EntityType", "EntityId")
);

CREATE INDEX "IDX_UserAccessRights_EntityId-EntityType-OwnerId"
    ON public."UserAccessRights" USING btree
    ("EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST,"OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_UserAccessRights_UserId-EntityId-EntityType"
    ON public."UserAccessRights" USING btree
    ("UserId" ASC NULLS LAST, "EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST)
    TABLESPACE pg_default; 