CREATE TABLE public."UserActions" (
    "Id" bigserial PRIMARY KEY,
    "UserId" bigint NOT NULL,
    "Type" integer NOT NULL,
    "EntityType" integer NOT NULL,
    "EntityId" bigint NULL,
    "IsAdditional" boolean DEFAULT false NOT NULL,
    "Date" timestamp without time zone NOT NULL,
    "Json" text  NULL,
    "Hash" character varying(64),
    "Description" character varying(500),
    "TypeCode" character varying(500) NULL,
    "UserName" character varying(120) NULL,
    "CustomerId" int NULL
);

CREATE INDEX "UserActions_IDX_EntityId-EntityType"
    ON public."UserActions" USING btree
    ("EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX "UserActions_IDX_UserId-Date"
    ON public."UserActions" USING btree
    ("UserId" ASC NULLS LAST, "Date" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX "UserActions_IDX_CustomerId"
	ON public."UserActions" USING btree
		("CustomerId" ASC NULLS LAST)
	TABLESPACE pg_default;
