CREATE TABLE public."UserAddressBookLinks" (
    "Id" bigserial,
    "Name" character varying(500) NOT NULL, 
    "Surname" character varying(255),
    "FirstName" character varying(255),
    "MiddleName" character varying(255),
    "ContactId" bigint NOT NULL, 
    "OwnerId" bigint NULL, 
    "AddressBookId" bigint NOT NULL, 
    "Department" character varying(500) NULL, 
    "Company" character varying(500) NULL, 
    "Position" character varying(500) NULL, 
    "Address" character varying(4000) NULL, 
    "About" character varying(4000) NULL, 
    "BirthDate" timestamp without time zone  NULL,
    "PhoneNumbers" character varying(4000) NULL,
    "LocalPhone" character varying(25), 
    "Email" character varying(500) NULL, 
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
     PRIMARY KEY ("AddressBookId", "ContactId")

);

		CREATE INDEX "UserAddressBookLinks_IDX_Name"
 		   ON public."UserAddressBookLinks" USING btree
 		   ("AddressBookId" ASC NULLS LAST, "Name" COLLATE pg_catalog."default" ASC NULLS LAST)
 		   TABLESPACE pg_default;

		CREATE INDEX "UserAddressBookLinks_IDX_Id"
  		  ON public."UserAddressBookLinks" USING btree
 		   ("Id" ASC NULLS LAST)
 		   TABLESPACE pg_default;

	CREATE INDEX "UserAddressBookLinks_IDX_OwnerId_ContactId"
  		  ON public."UserAddressBookLinks" USING btree
 		   ("OwnerId" ASC NULLS LAST,"ContactId" ASC NULLS LAST,"ContactId" ASC NULLS LAST,"PhoneNumbers" ASC NULLS LAST)
 		   TABLESPACE pg_default;