CREATE TABLE public."GroupEntityRelations" (
    "Id" bigserial,
    "EntityId" bigint not null,
    "GroupId" bigint not null,
    "CreatedAt" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    CONSTRAINT "GroupEntityRelations_pkey" PRIMARY KEY ("EntityId","GroupId")
);
CREATE INDEX IF NOT EXISTS "IDX_GroupEntityRelations-GroupId-Id"
    ON public."GroupEntityRelations" USING btree
    ("GroupId" ASC NULLS LAST, "Id" ASC NULLS LAST)
    TABLESPACE pg_default;