CREATE TABLE IF NOT EXISTS public."ProjectTasks"
(
    "Id" bigserial NOT NULL,
    "TypeId" bigint NOT NULL,
    "ParentId" bigint,
    "AuthorId" bigint NOT NULL,
    "PerformerId" bigint,
    "PerformerRoleId" bigint,
    "Priority" integer NOT NULL,
    "Status" integer NOT NULL,
    "State" integer DEFAULT 1,
    "Key" character varying(512),
    "Title" character varying(4000),
    "Description" text,
    "ProjectId" bigint NOT NULL,
    "SprintId" bigint,
    "Updated" timestamp without time zone,
    "StartDate" timestamp without time zone,
    "EndDate" timestamp without time zone,
    "DueDate" timestamp without time zone,
    "Estimated" bigint,
    "TimeLeft" bigint,
    "TimeSpent" bigint,
    "HasLinks" boolean DEFAULT false,
    "HasAttributes" boolean DEFAULT false,
    "HasChildren" boolean DEFAULT false,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "HasAttachments" boolean DEFAULT false,
    "Order" bigint DEFAULT 0,
    "DeleteUserId" bigint NULL,
    CONSTRAINT "ProjectTasks_pkey" PRIMARY KEY ("Id")
);
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTasks-Key"
    ON public."ProjectTasks" USING btree
    ("Key"ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTasks-ProjectId-AuthorId-All"
    ON public."ProjectTasks" USING btree
    ("ProjectId" ASC NULLS LAST, "SprintId" ASC NULLS LAST, "ParentId" ASC NULLS LAST, "AuthorId" ASC NULLS LAST, "PerformerId" ASC NULLS LAST, "TypeId" ASC NULLS LAST, "Priority" ASC NULLS LAST, "Updated" ASC NULLS LAST, "Status" ASC NULLS LAST, "Order" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_ProjectTasks-Id-ProjectId"
    ON public."ProjectTasks" USING btree
    ("Id"ASC NULLS LAST,"ProjectId"ASC NULLS LAST)
    TABLESPACE pg_default; 