#!/bin/bash

HAVE_ERROR="false"

LOCAL_SITE_DOMAIN=$(whiptail --title  "Проверка установки" --inputbox  "Domain :" 10 60 local.ru 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "cddisk site domain: $LOCAL_SITE_DOMAIN"
else
    $LOCAL_SITE_DOMAIN = "local.r7-office.ru"
    echo "cddisk site domain: $LOCAL_SITE_DOMAIN"
fi

if (whiptail --title "Проверка установки" --yesno "Make HTTPS?" 10 60); then
    MAKE_HTTPS=true;
else
    MAKE_HTTPS=false;
fi

PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for cddisk:" 10 60 cddisk 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "cddisk prefix: $PREFIX"
else
    $PREFIX = "cddisk"
    echo "cddisk sprefix: $PREFIX"
fi

ADMIN_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for admin:" 10 60 admin 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "admin prefix: $ADMIN_PREFIX"
else
    $ADMIN_PREFIX = "admin"
    echo "admin sprefix: $ADMIN_PREFIX"
fi

CDMAIL_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for cdmail:" 10 60 cdmail 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "cdmail prefix: $CDMAIL_PREFIX"
else
    $CDMAIL_PREFIX = "cdmail"
    echo "cdmail sprefix: $CDMAIL_PREFIX"
fi

CONTACTS_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for contacts:" 10 60 contacts 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "contacts prefix: $CONTACTS_PREFIX"
else
    $CONTACTS_PREFIX = "contacts"
    echo "contacts sprefix: $CONTACTS_PREFIX"
fi

PROJECTS_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for projects:" 10 60 projects 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "projects prefix: $PROJECTS_PREFIX"
else
    $PROJECTS_PREFIX = "projects"
    echo "projects sprefix: $PROJECTS_PREFIX"
fi

CALENDAR_PREFIX=$(whiptail --title  "Проверка установки" --inputbox  "Prefix for calendar:" 10 60 calendar 3>&1 1>&2 2>&3)
exitstatus=$?
if [ $exitstatus = 0 ];  then
    echo "calendar prefix: $CALENDAR_PREFIX"
else
    $CALENDAR_PREFIX = "calendar"
    echo "calendar sprefix: $CALENDAR_PREFIX"
fi

echo "MAKE_HTTPS=$MAKE_HTTPS"

echo "Пауза 30 секунд для ожидания запуска сервисов"
sleep 30

echo "Сервисы, которые неактивны или не включены при запуске:"

for name in ds-metrics ds-converter ds-docservice supervisord postgresql rabbitmq redis nginx; do
    isActive=$(systemctl is-active ${name})
    isEnabled=$(systemctl is-enabled ${name})

    if [ "$isActive" == "inactive" ] || [ "$isEnabled" == "disabled" ]; then
        echo "Сервис: ${name}"
        echo "  Активность: $isActive"
        echo "  Автозапуск: $isEnabled"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

echo "Введите пароль администратора для контроля наличия лог-файлов"
sudo /opt/r7-office/r7-logcheck.sh
if [ $? -ne 0 ]; then
	HAVE_ERROR="true"
fi

base_domain=$LOCAL_SITE_DOMAIN

sites=(
"$base_domain"
"$ADMIN_PREFIX.$base_domain"
"$PREFIX.$base_domain"
"$CONTACTS_PREFIX.$base_domain"
"$CALENDAR_PREFIX.$base_domain"
"$CDMAIL_PREFIX.$base_domain"
"$PROJECTS_PREFIX.$base_domain"
)

for site in "${sites[@]}"; do
    if [ "$MAKE_HTTPS" = "true" ]; then
        response_code=$(curl -o /dev/null -s -w "%{http_code}" "https://$site")
    else
        response_code=$(curl -o /dev/null -s -w "%{http_code}" "http://$site")
    fi

    if [[ $response_code -eq 200 ]]; then
        echo "Сайт $site успешно открывается."
    else
        echo "Сайт $site не открывается или возвращает код ошибки: $response_code"
        HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

if [ $MAKE_HTTPS = "true" ]; then
endpoints=(
"https://$PREFIX.$base_domain/api/v1/version"
"https://$ADMIN_PREFIX.$base_domain/api/v1/version"
"https://$CONTACTS_PREFIX.$base_domain/api/v1/version"
"https://$CDMAIL_PREFIX.$base_domain/api/v1/version"
"https://$CALENDAR_PREFIX.$base_domain/api/v1/version"
"https://$PROJECTS_PREFIX.$base_domain/api/v1/version"
)
else
endpoints=(
"http://$PREFIX.$base_domain/api/v1/version"
"http://$ADMIN_PREFIX.$base_domain/api/v1/version"
"http://$CONTACTS_PREFIX.$base_domain/api/v1/version"
"http://$CDMAIL_PREFIX.$base_domain/api/v1/version"
"http://$CALENDAR_PREFIX.$base_domain/api/v1/version"
"http://$PROJECTS_PREFIX.$base_domain/api/v1/version"
)
fi

for endpoint in "${endpoints[@]}"; do
    echo "Проверка $endpoint ..."
    
    response=$(curl -s "$endpoint")

    # Проверка на наличие ошибок в запросе
    if [[ $? -eq 0 ]]; then
        version=$(echo $response | /opt/r7-office/installtools/json Version)
        name=$(echo $response | /opt/r7-office/installtools/json Name)
        copyright=$(echo $response | /opt/r7-office/installtools/json Copyrigth)
        
        echo "Имя: $name"
        echo "Версия: $version"
        echo "Авторские права: $copyright"
        if [ -z "${oldname}" ] && [ -z "${oldversion}" ] && [ -z "${oldcopyright}" ] ; then
            oldname="${name}"
            oldversion="${version}"
            oldcopyright="${copyright}"
        else
            if [ "${oldname}" != "${name}" ];then
	        echo "Не совпадает имя ${oldname} != ${name}"
		HAVE_ERROR="true"
		echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
            if [ "${oldversion}" != "${version}" ];then
	        echo "Не совпадает версия ${oldversion} != ${version}"
		HAVE_ERROR="true"
		echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
            if [ "${oldcopyright}" != "${copyright}" ];then
	        echo "Не совпадает версия ${oldcopyright} != ${copyright}"
		HAVE_ERROR="true"
		echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
        fi
    else
        echo "Ошибка при доступе к $endpoint"
        HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
    echo "---------------------------"
done

if [ $HAVE_ERROR = "true" ]; then
echo -e "\e[31m❌ Ошибка  \e[0m"
echo "-----------------------------------------"
echo "|                                       |"
echo "|  Если возникла ошибка или нужна       |"
echo "|  помощь, обратитесь:                  |"
echo "|  support@r7-office.ru                 |"
echo "|                                       |"
echo "|  С уважением к Вам,                   |"
echo "|  Команда Р7                           |"
echo "|                                       |"
echo "-----------------------------------------"
echo -e "\nЧтобы получить доступ откройте в браузере:"
echo "Логин и пароль администратора superadmin superadmin"
if [ $MAKE_HTTPS = "true" ]; then
    echo "Админ: https://$ADMIN_PREFIX.$base_domain"
    echo "Диск: https://$PREFIX.$base_domain"
    echo "Контакты: https://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: https://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: https://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: https://$PROJECTS_PREFIX.$base_domain"
else
    echo "Админ: http://$ADMIN_PREFIX.$base_domain"
    echo "Диск: http://$PREFIX.$base_domain"
    echo "Контакты: http://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: http://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: http://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: http://$PROJECTS_PREFIX.$base_domain"
fi
else
echo -e "\e[32m✅ Установка прошла успешно  \e[0m"
# Приветственное сообщение
echo -e "\nЧтобы получить доступ откройте в браузере:"
echo "Логин и пароль администратора superadmin superadmin"
if [ $MAKE_HTTPS = "true" ]; then
    echo "Админ: https://$ADMIN_PREFIX.$base_domain"
    echo "Диск: https://$PREFIX.$base_domain"
    echo "Контакты: https://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: https://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: https://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: https://$PROJECTS_PREFIX.$base_domain"
else
    echo "Админ: http://$ADMIN_PREFIX.$base_domain"
    echo "Диск: http://$PREFIX.$base_domain"
    echo "Контакты: http://$CONTACTS_PREFIX.$base_domain"
    echo "Календарь: http://$CALENDAR_PREFIX.$base_domain"
    echo "Почта: http://$CDMAIL_PREFIX.$base_domain"
    echo "Проекты: http://$PROJECTS_PREFIX.$base_domain"
fi
fi

read -p "Для удаления автоматической проверки введите пароль администратора. Нажмите ENTER для продолжения" answer

sudo rm -f /etc/xdg/autostart/r7-healcheck.desktop 
