window.initCounter = 0;
window.isModeSafe = false;
function on_init_server(type)
{
    if (type === (window.initCounter & type))
        return;
    window.initCounter |= type;
    if (window.initCounter === 3)
    {
        load_library("r7", "./libs/" + Asc.plugin.info.editorType + "/api.js");
    }
}

function load_library(name, url) 
{
    var xhr = new XMLHttpRequest();
    xhr.open("GET", url, true);
    xhr.onreadystatechange = function() 
    {
        if (xhr.readyState == 4)
        {
            var EditSession = ace.require("ace/edit_session").EditSession;
            var editDoc = new EditSession(xhr.responseText, "ace/mode/javascript");
            editor.ternServer.addDoc(name, editDoc);
        }
    };
    xhr.send();
}


document.addEventListener("DOMContentLoaded", function() {
    var styleTheme = document.createElement('style');
    styleTheme.type = 'text/css';

    window.lockTooltipsPosition = true;
    var editor_elem = document.getElementById("editorWrapper");
    var rules = ".Ace-Tern-tooltip {\
box-sizing: border-box;\
max-width: " + editor_elem.offsetWidth + "px !important;\
min-width: " + editor_elem.offsetWidth + "px !important;\
left: " + editor_elem.offsetLeft + "px !important;\
bottom: " + parseInt(document.getElementsByClassName("divFooter")[0].offsetHeight) + "px !important;\
}";

    styleTheme.innerHTML = rules;
    document.getElementsByTagName('head')[0].appendChild(styleTheme);
});

var editor = ace.edit("editor");      
editor.session.setMode("ace/mode/javascript");
editor.setValue("");


editor.getSession().setUseWrapMode(true);
editor.getSession().setWrapLimitRange(null, null);
editor.setShowPrintMargin(false);
editor.$blockScrolling = Infinity;

ace.config.loadModule('ace/ext/tern', function () {
    editor.setOptions({
        enableTern: {
            defs: ['browser', 'ecma5'],
            plugins: { doc_comment: { fullDocs: true } },
            useWorker: !!window.Worker,            
            switchToDoc: function (name, start) {},            
            startedCb: function () {
                on_init_server(1);
            },
        }, 
        enableSnippets: false,
        enableBasicAutocompletion: true,
    });
});

ace.config.loadModule('ace/ext/html_beautify', function (beautify) {
    editor.setOptions({
        autoBeautify: true,
        htmlBeautify: true,
    });
    window.beautifyOptions = beautify.options;
});

(function(window, undefined){

    var Content = {

        macrosArray : [],
        
        current : -1
    };
    // подпись макросов отключена в веб-версии
    var isMacrosSigningDisabled = !window.AscDesktopEditor;

    editor.getSession().on('change', function() {
        
        if (Content.current == -1 || window.isDisable)
            return;

        Content.macrosArray[Content.current].value = editor.getValue();        

    });

    function create_guid(a,b)
    {
       for(b=a='';a++<36;b+=a*51&52?(a^15?8^Math.random()*(a^20?16:4):4).toString(16):'');
       return b
    };

    function updateMenu()
    {
        if (Content.current < 0)
            Content.current = 0;
        if (Content.current >= Content.macrosArray.length)
            Content.current = Content.macrosArray.length - 1;
            
        var menuContent = "";
        for (var i = 0; i < Content.macrosArray.length; i++)
        {
            var cl = (i == Content.current) ? "macrosSelected" : "macros";
			var name = $('<div/>').text(Content.macrosArray[i].name).html();
            var item = "<div class=\"" + cl + "\" id=\"item" + i + "\" onclick=\"window.onItemClick(" + i + ");\">" + name;
            if (true === Content.macrosArray[i].autostart) {
                var PropForMac = "";
                if (navigator.userAgent.indexOf('Macintosh') != -1) {
                    PropForMac = "style = \"top : calc(50% - 6px)\"";
                }
                item += ("<div class=\"macrosAutostart\"" +PropForMac+ ">(A)</div>");
            }
            item += "</div>";
            menuContent += item;

            if (!Content.macrosArray[i]["guid"])
                Content.macrosArray[i]["guid"] = create_guid();
        }
        
        var elem = document.getElementById("menu_content");
        elem.innerHTML = menuContent;
        
        onItemClick(Content.current, true);
        updateScrollMenu();
    }

    function onItemClick(index, isAttack)
    {
        if (index != Content.current || isAttack)
        {
            for (var i = 0; i < Content.macrosArray.length; i++)
            {
                var elem = document.getElementById("item" + i);
                if (i == index)
                {
                    elem.classList.remove("macros");
                    elem.classList.add("macrosSelected");
                }
                else if (i == Content.current)
                {
                    elem.classList.remove("macrosSelected");
                    elem.classList.add("macros");
                }
            }
            Content.current = index;
        }
        
        var buttonAutoStart = document.getElementById("button_autostart");
        var buttonSign = document.getElementById("button_sign");
        (window.isModeBlocked || window.isModeSafe) && document.getElementById("button_run").setAttribute("disabled", "disabled");

        if (-1 == Content.current)
        {
            window.isDisable = true;
            editor.setValue('');
            editor.setReadOnly(true);
            window.isDisable = false;
            buttonAutoStart.style.display = "none";
            if (window.isModeSafe) {
                buttonSign.style.display = "none"
            }
        }
        else
        {
            window.isDisable = true;
            editor.setValue(Content.macrosArray[index].value);
            editor.setReadOnly(false);
            window.isDisable = false;
            buttonAutoStart.style.display = "inline-block";
            if (window.isModeSafe) {
                buttonSign.style.display = "inline-block";
            }
            editor.focus();
            if (Content.macrosArray[Content.current].autostart) { // R7
                buttonAutoStart.classList.add("primary");
                // buttonSign.classList.add("primary"); // R7
            } else { // R7
                buttonAutoStart.classList.remove("primary");
                // buttonSign.classList.remove("primary"); // R7
            } // R7
        }
        verifyMacros();
        editor.selection.clearSelection();
    }
    window.onItemClick = onItemClick;

    async function isModeBlockedMacroses() {
        return await new Promise((resolve) => {
            window.Asc.plugin.executeMethod("IsModeBlockedMacroses", [], (isModeBlocked) => {
                resolve(isModeBlocked);
            });
        })
    }

    async function isModeSafeMacroses() {
        return await new Promise((resolve) => {
            window.Asc.plugin.executeMethod("IsModeSafeMacroses", [], (isModeSafe) => {
                resolve(isModeSafe);
            });
        })
    }

    function verifyMacros() {
        if (!window.isModeSafe) {
            return;
        }

        window.Asc.plugin.executeMethod("VerifyMacros", [JSON.stringify(Content.macrosArray[Content.current])], function (isVerify) {
            let buttonRun = document.getElementById("button_run");
            if (isVerify) {
                buttonRun.removeAttribute("disabled");
            } else {
                buttonRun.setAttribute("disabled", "disabled");
            }
        });
    }

    function parseInfo(list) {
        if (!Array.isArray(list)) {
            throw new Error('ECPMPINA')
        }

        return list.map(function (i) {
            try {
                if (i.Signer) {
                    i.Signer = b64parse(i.Signer)
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMPIPSR')
            }

            try {
                if (i.Issuer) {
                    i.Issuer = b64parse(i.Issuer)
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMPIPI')
            }

            try {
                if (i.Subject) {
                    i.Subject = b64parse(i.Subject)
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMPIPS')
            }

            function b64parse(str) {
                return atob(str)
                    .split('')
                    .map(function (x) {
                        var c = x.charCodeAt();
                        if (c >= 192) {
                            return c - 192 + 1040;
                        }
                        return c;
                    })
                    .map(function (c) {
                        return String.fromCharCode(c);
                    })
                    .join('');
            }
            return i;
        });
    }

    function transformList(list) {
        return list.map(function (x) {
            try {
                if (x.Signer) {
                    x.Signer = parseInfo([x.Signer]);
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMTLSR')
            }

            try {
                if (x.Issuer) {
                    x.Issuer = parseSignRaw(x.Issuer);
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMTLI')
            }

            try {
                if (x.Subject) {
                    x.Subject = parseSignRaw(x.Subject);
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMTLS')
            }

            try {
                if (x.NotAfter) {
                    x.NotAfter = parseUtcDate(x.NotAfter);
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMTLNA')
            }

            try {
                if (x.NotBefore) {
                    x.NotBefore = parseUtcDate(x.NotBefore);
                }
            } catch (err) {
                console.error(err)
                throw new Error('ECPMTLNB')
            }
            return x;
        });
    }

    function parseSignRaw(raw) {
        return Object.fromEntries(
            raw
                .split(/^(?:([А-ЯA-Z]+)=)|(?:, ([А-ЯA-Z]+)=)/)
                .filter(Boolean)
                .reduce(function (p, n, i, a) {
                    return i % 2 === 0 ? p.concat([[n, a[i + 1]]]) : p;
                }, [])
                .map(function (x) {
                    x[1] = x[1].replace(/^"/, '').replace(/"$/, '');
                    return x;
                }),
        );
    }

    function parseUtcDate(date) {
        const regex = /^(\d{2})\/(\d{2})\/(\d{4}) (\d{2}):(\d{2}):(\d{2}) UTC$/;
        if (regex.test(date)) {
            return new Date(
                date.replace(regex, (_, p1, p2, p3, p4, p5, p6) =>
                    new Date(Date.UTC(+p3, +p2 - 1, +p1, +p4, +p5, +p6)).toISOString(),
                ),
            );
        }
        date = new Date(date);
        if (!+date) {
            return new Date('0000-00-00');
        }
        return date;
    }

    function getCeritificates(provider) {
        var list = [];
        var providerType = 0;
        var res = JSON.parse(
            window.AscDesktopEditor.execCommand(
                'kzn_unit',
                JSON.stringify({
                    method: 'get_list',
                    args: {
                        provider: provider || (providerType === 0) ? "CryptoPRO" : ((providerType === 1) ? "Native" : "OpenSSL")
                    }
                }),
            ),
        );

        if (res && res.error != null) {
            console.error(res.error);
            throw new Error(res.error)
        } else {
            list = parseInfo(res.data);
            list = transformList(list);
        }
        return list;
    }

    document.getElementById("button_new").onclick = function() {
        var indexMax = 0;
        var macrosTranslate = window.Asc.plugin.tr("Macros");
        for (var i = 0; i < Content.macrosArray.length; i++)
        {
            if (0 == Content.macrosArray[i].name.indexOf("Macros"))
            {
                var index = parseInt(Content.macrosArray[i].name.substr(6));
                if (!isNaN(index) && (indexMax < index))
                    indexMax = index;
            }
            else if (0 == Content.macrosArray[i].name.indexOf(macrosTranslate))
            {
                var index = parseInt(Content.macrosArray[i].name.substr(macrosTranslate.length));
                if (!isNaN(index) && (indexMax < index))
                    indexMax = index;
            }
        }
        indexMax++;
        Content.macrosArray.push({ name : (macrosTranslate + " " + indexMax), value : "(function()\n{\n})();" });
        Content.current = Content.macrosArray.length - 1;
        updateMenu();
        editor.focus();
        verifyMacros();
    };
    document.getElementById("button_delete").onclick = function() {
        if (Content.current != -1)
        {
            Content.macrosArray.splice(Content.current, 1);
            updateMenu();
        }
    };
    document.getElementById("button_rename").onclick = function() {
        showRename();
    };
    document.getElementById("button_autostart").onclick = function() {
        Content.macrosArray[Content.current].autostart = Content.macrosArray[Content.current].autostart ? false : true;
        onItemClick(Content.current);
        updateMenu();
    };
    
    document.getElementById("button_sign").onclick = function() {
        if (isMacrosSigningDisabled) {
            document.getElementById("idSignWarningMask").style.display = "block";
            document.getElementById("idSignWarning").style.display = "block";
            return;
        }

        showCert();
    };
    
    // setTimeout(showCert, 1000);

    document.getElementById("button_run").onclick = function() {
        if (Content.current != -1)
        {
            window.Asc.plugin.info.recalculate = true;
            window.Asc.plugin.info.macrosGuid = Content.macrosArray[Content.current].guid;
            window.Asc.plugin.info.macrosName = Content.macrosArray[Content.current].name;
            if (Content.macrosArray[Content.current] && Content.macrosArray[Content.current].signature) {
                window.Asc.plugin.info.signature = Content.macrosArray[Content.current].signature;
            }

            window.Asc.plugin.executeCommand("command", Content.macrosArray[Content.current].value);
            // window.Asc.plugin.executeCommand("command", Content.macrosArray[Content.current]);
            verifyMacros(); // Только для визуальной блокировки кнопки run, макрос не выполнится если не подписан в движке
        }
    };

    document.getElementById("cert_ok").onclick = function() {
        unShowCert(true);
    };
    document.getElementById("cert_cancel").onclick = function() {
        unShowCert(false);
    };

    document.getElementById("rename_ok").onclick = function() {
        unShowRename(true);
    };
    document.getElementById("rename_cancel").onclick = function() {
        unShowRename(false);
    };

    document.getElementById("sign_warning_ok").onclick = function() {
        document.getElementById("idSignWarningMask").style.display = "none";
        document.getElementById("idSignWarning").style.display = "none";
    };

	document.addEventListener("keydown", function(event)
	{
		if ( (event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 's')
		{
			event.preventDefault();
			event.stopPropagation();
			if (!isShowRename)
			{
				window.Asc.plugin.executeMethod("SetMacros", [JSON.stringify(Content)], function() {});
			}
		}
	}, false);

	document.addEventListener("keyup", function(event)
	{
		if ( (event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 's')
		{
			event.preventDefault();
			event.stopPropagation();
		}
		verifyMacros(); // Только для визуальной блокировки кнопки run, макрос не выполнится если не подписан в движке
	}, false);

	Ps = new PerfectScrollbar("#menu", {});
    updateScrollMenu();

    function updateScrollMenu()
    {
        Ps.update();
    }

    // certificate
    var isShowCert = false;
    function showCert()
    {
        if (Content.current < 0)
            return;

        showSignatureList();

        var _elem1 = document.getElementById("idCertMask");
        var _elem2 = document.getElementById("idCert");
        _elem1.style.display = "block";
        _elem2.style.display = "block";

        isShowCert = true;
    }

    function showSignatureList() {
        try {
            var ceritificates = getCeritificates();
            renderCertificates(ceritificates);
        } catch (err) {
            function isString(value) {
                return typeof value === 'string' || value instanceof String;
            }

            var msg = 'ECPMASLGL';

            if (isString(err)) {
                msg = err
            }

            if (err && err.message) {
                msg = err.message
            }

            if (err && err.error) {
                msg = err.error
            }

            console.warn(err);
            console.warn(msg);
        }
    }

    var selectedCertId = '';

    function renderCertificates(certificates) {
        let view = ''

        const selectBtn = document.getElementById('cert_ok');
        selectBtn.classList.add('disabled')

        certificates.forEach((item) => {
          let friendlyName = ''
          if (item.FriendlyName) {
            friendlyName = item.FriendlyName
          }
      
          const status = isCertValid(item) ? 'cert-item-active' : 'cert-item-inactive'
      
          view += `<div id="${item.SerialNumber}" class="cert-item ${status}">
          <div class="cert-item-subject">${item.Subject['CN']}</div>
          <div class="cert-item-issuer">${item.Issuer['CN']}</div>
      </div>`
        })
        const hub = document.getElementsByClassName('cert-list')[0]
        hub.innerHTML = view;

        hub.onclick = async (event) => {
            event.preventDefault();

            // reset select cert
            certificates.forEach((item) => {
                if (item.SerialNumber) {
                    let el = document.getElementById(item.SerialNumber);
                    el.classList.remove('cert-selected');
                }
            })

            var path = event.composedPath ? event.composedPath() : event.path;

            path.some((item) => {
                if (item && item.id) {
                    const cert = certificates.find((el) => el.SerialNumber == item.id);
                    cert && renderCertDetails(cert);
                    return true
                }
                return false
            })
          }
    }

    function renderCertDetails(cert) {
        let dls = document.getElementsByClassName('cert-info')[0]
        let dds = dls.getElementsByTagName('dd')
        const txtNotData = 'Нет данных'

        const selectBtn = document.getElementById('cert_ok');
        selectBtn.classList.add('disabled')

        // Нажали на то же самый сертификат
        if (cert.SerialNumber === selectedCertId) {
            selectedCertId = ''
            dls.classList.add('cert-noresult');
            return
        }

        selectedCertId = cert.SerialNumber || '';
        dls.classList.add('cert-noresult')
        // settings.classList.add('cert-noresult')

        for (let i = 0, len = 7; i < len; i++) {
            dds[0].innerHTML = txtNotData
        }

        if (cert) {
            let el = document.getElementById(cert.SerialNumber)
            el.classList.add('cert-selected')

            dls.classList.remove('cert-noresult')
            // settings.classList.remove('cert-noresult')

            dds[0].innerHTML = isCertValid(cert) ? window.Asc.plugin.tr("CertValid") : window.Asc.plugin.tr("CertInvalid") // Статус
            dds[1].innerHTML = cert.Subject['CN']; // Владелец сертификата
            dds[2].innerHTML = cert.Subject['O']; // Криптопровайдер
            dds[3].innerHTML = cert.Issuer['CN']; // Индентификатор криптопровайдера
            dds[4].innerHTML = cert.NotBefore.toLocaleString('ru-RU'); // Выдан
            dds[5].innerHTML = cert.NotAfter.toLocaleString('ru-RU'); // Годен до
            dds[6].innerHTML = cert.SerialNumber.replace(/^0x/, ''); // Индентификатор сертификата

            selectBtn.classList.remove('disabled')
        }
    }

    function isCertValid(item) {
        return (
          Date.now() > +new Date(item.NotBefore) && Date.now() < +new Date(item.NotAfter)
        )
    }

    function unShowCert(isOK)
    {

        let dls = document.getElementsByClassName('cert-info')[0]
        dls.classList.add('cert-noresult');
        isShowCert = false;

        var _elem1 = document.getElementById("idCertMask");
        var _elem2 = document.getElementById("idCert");
        _elem1.style.display = "none";
        _elem2.style.display = "none";

        if (Content.current < 0 || !isOK) {
            selectedCertId = '';
            return;
        }

        if (!selectedCertId) {
            return;
        }
        Content.macrosArray[Content.current].serialNumberCertificate = selectedCertId;
        window.Asc.plugin.executeMethod("SignMacros", [JSON.stringify(Content.macrosArray[Content.current])], function (data) {
            delete Content.macrosArray[Content.current].serialNumberCertificate;
            if (data && data.trim() && typeof data === 'string') {
                Content.macrosArray[Content.current].signature = data;
            }
            verifyMacros();
        });
        selectedCertId = '';
    }

    // rename
    var isShowRename = false;
    function showRename()
    {
        if (Content.current < 0)
            return;

        var _elem1 = document.getElementById("idRenameMask");
        var _elem2 = document.getElementById("idRename");
        _elem1.style.display = "block";
        _elem2.style.display = "block";
        document.getElementById("rename_text").value = Content.macrosArray[Content.current].name;
        document.getElementById("rename_text").select();

        isShowRename = true;
    }

    function unShowRename(isOK)
    {
        var value = document.getElementById("rename_text").value;

        if ((isOK && value) || !isOK) {
            var _elem1 = document.getElementById("idRenameMask");
            var _elem2 = document.getElementById("idRename");
            _elem1.style.display = "none";
            _elem2.style.display = "none";
            document.getElementById("input_error_id").style.display = "none";
            document.getElementById("rename_text").style.borderColor = "#cfcfcf";
            isShowRename = false;
        }
        

        if (Content.current < 0)
            return;

        if (isOK && value)
        {
            Content.macrosArray[Content.current].name = value;
            updateMenu();
        } else if (isOK && !value) {
            document.getElementById("input_error_id").style.display = "block";
            document.getElementById("rename_text").style.borderColor = "#d9534f";
        }

        value.value = "";
    }

    window.onresize = function()
    {
        updateScrollMenu();
    }

    window.onkeydown = function(e)
    {
        if (isShowRename)
        {
            switch (e.keyCode)
            {
                case 27:
                {
                    unShowRename(false);
                    break;
                }
                case 13:
                {
                    unShowRename(true);
                    break;
                }
                default:
                    break;
            }
        }
    }

    window.Asc.plugin.init = async function(text)
	{
        on_init_server(2);

        window.isModeBlocked = await isModeBlockedMacroses();
        window.isModeSafe = await isModeSafeMacroses();

        window.Asc.plugin.resizeWindow(undefined, undefined, 400, 300, 0, 0);

        this.executeMethod("GetMacros", [JSON.stringify(Content)], function(data) {
            
            try
            {
                Content = JSON.parse(data);

                for (var i = 0; i < Content.macrosArray.length; i++)
                {
                    var value = Content.macrosArray[i].name;
                    if (undefined === value)
                        value = "";

                    Content.macrosArray[i].name = value;
                }
            }
            catch (err)
            {
                Content = {
                    macrosArray : [],
                    current : -1
                };
            }

            window.Asc.plugin.executeMethod("GetVBAMacros", null, function(data) {
                if (data && typeof data === 'string' && data.includes('<Module')) {
                    var arr = data.split('<Module ').filter(function(el){return el.includes('Type="Procedural"')});
                    arr.forEach(function(el) {
                        var start = el.indexOf('<SourceCode>') + 12;
                        var end = el.indexOf('</SourceCode>', start);
                        var macros = el.slice(start, end);
	
                        start = el.indexOf('Name="') + 6;
                        end = el.indexOf('"', start);
                        var name = el.slice(start, end);
                        var index = Content.macrosArray.findIndex(function(macr){return macr.name == name});
                        if (index == -1) {
                            macros = macros.replace(/&amp;/g,'&');
                            macros = macros.replace(/&lt;/g,'<');
                            macros = macros.replace(/&gt;/g,'>');
                            macros = macros.replace(/&apos;/g,'\'');
                            macros = macros.replace(/&quot;/g,'"');
                            macros = macros.replace(/Attribute [\w \.="\\]*/g,'');
                            Content.macrosArray.push(
                                {
                                    name: name,
                                    value: '(function()\n{\n\t/* Enter your code here. */\n})();\n\n/*\nExecution of VBA commands does not support.\n' + macros + '*/',
                                    guid: create_guid()
                                }
                            );
                        }
                    });
                }
                updateMenu();
                window.CustomContextMenu.init();
                if (Content.current === -1)
                {
                    document.getElementById("button_new").onclick();
                }
            });
        });

        var _textbox = document.getElementById("rename_text");
        // clear validation on input/paste
        _textbox.oninput = _textbox.onpaste = function(e)
        {
            this.style.borderColor = "";
            document.getElementById("input_error_id").style.display = "none";
        };
        // ie
        _textbox.addEventListener("paste", function(e)
        {
            this.style.borderColor = "";
            document.getElementById("input_error_id").style.display = "none";
        });
	};
	
	window.Asc.plugin.button = function(id)
	{   
        if (id == 0)
        {
            this.executeMethod("SetMacros", [JSON.stringify(Content)], function(){
                window.Asc.plugin.executeCommand("close", "");    
            });
        }
        else
        {
            this.executeCommand("close", "");
        }
    };
    
    window.Asc.plugin.onExternalMouseUp = function()
    {
        var evt = document.createEvent("MouseEvents");
        evt.initMouseEvent("mouseup", true, true, window, 1, 0, 0, 0, 0,
            false, false, false, false, 0, null);

        document.dispatchEvent(evt);
    };
	
	window.Asc.plugin.onTranslate = function()
	{
		document.getElementById("button_new").innerHTML = window.Asc.plugin.tr("New");
		document.getElementById("button_delete").innerHTML = window.Asc.plugin.tr("Delete");
        document.getElementById("button_rename").innerHTML = window.Asc.plugin.tr("Rename");
        document.getElementById("button_autostart").innerHTML = window.Asc.plugin.tr("Autostart");
        document.getElementById("button_run").innerHTML = window.Asc.plugin.tr("Run");
        document.getElementById("rename_ok").innerHTML = window.Asc.plugin.tr("Ok");
        document.getElementById("rename_cancel").innerHTML = window.Asc.plugin.tr("Cancel");
        document.getElementById("cert_ok").innerHTML = window.Asc.plugin.tr("Ok");
        document.getElementById("cert_cancel").innerHTML = window.Asc.plugin.tr("Cancel");
        document.getElementById("input_error_id").title = window.Asc.plugin.tr("Title");
        document.getElementById("button_sign").innerHTML = window.Asc.plugin.tr("Sign");
        document.getElementById("sign_warning_message").innerHTML = window.Asc.plugin.tr("SignWarning");
        document.getElementById("sign_warning_ok").innerHTML = window.Asc.plugin.tr("Ok");

        // Сертификаты
        let certInfo = document.getElementsByClassName('cert-info-title')[0];
        certInfo.innerHTML = window.Asc.plugin.tr("CertInfo");

        let dls = document.getElementsByClassName('cert-info')[0];

        let noSelectedCert = dls.getElementsByTagName('span')[0];
        noSelectedCert.innerHTML = window.Asc.plugin.tr("CertNoSelected");

        let dts = dls.getElementsByTagName('dt')
        dts[0].innerHTML = window.Asc.plugin.tr("CertStatus");
        dts[1].innerHTML = window.Asc.plugin.tr("CertOwner");
        dts[2].innerHTML = window.Asc.plugin.tr("CertCryptoProvider");
        dts[3].innerHTML = window.Asc.plugin.tr("CertIdCryptoProvider");
        dts[4].innerHTML = window.Asc.plugin.tr("CertDateIssued");
        dts[5].innerHTML = window.Asc.plugin.tr("CertValidUntil");
        dts[6].innerHTML = window.Asc.plugin.tr("CeryId");
    };
    
    // context menu
    window.CustomContextMenu = {
        element: null,
        visible: false,
        macrosIndex: 0,
        position: function(x, y) {
            if (!this.element)
                return;
            this.element.style.left = x + "px";
            this.element.style.top = y + "px";
            this.visible = true;
            this.element.style.display = "block";
        },
        hide: function(){
            this.visible = false;
            this.element.style.display = "none";
        },
        init: function(){
            if (this.element)
                return;
            this.element = document.getElementById("context-menu-id");
            window.addEventListener("click", function(e) {
                window.CustomContextMenu.visible && window.CustomContextMenu.hide();
            });
            window.addEventListener("contextmenu", function(e) {
                var className = e.srcElement.getAttribute("class");
                if (className && -1 != className.indexOf("macros"))
                {
                    e.preventDefault();
                    window.CustomContextMenu.macrosIndex = parseInt(e.srcElement.id.substr(4));
                    document.getElementById("menu_autostart_id").innerHTML = window.Asc.plugin.tr(
                        Content.macrosArray[window.CustomContextMenu.macrosIndex].autostart ? "Unmake autostart" : "Make autostart");
                    window.CustomContextMenu.position(e.pageX, e.pageY);
                    return;
                }
                if (e.srcElement.id && (0 == e.srcElement.id.indexOf("menu_") || 0 == e.srcElement.id.indexOf("button")))
                {
                    e.preventDefault();
                }
                if (window.CustomContextMenu.visible)
                    window.CustomContextMenu.hide();
            });
        },
        onAutostartClick: function()
        {
            if (!Content.macrosArray[window.CustomContextMenu.macrosIndex])
                return;
            
            Content.macrosArray[window.CustomContextMenu.macrosIndex].autostart = 
                Content.macrosArray[window.CustomContextMenu.macrosIndex].autostart ? false : true;

            updateMenu();
        }
    };

    window.Asc.plugin.onThemeChanged = function(theme)
    {
        window.Asc.plugin.onThemeChangedBase(theme);
        $('#menu_content, .ace_content').css('background', window.Asc.plugin.theme["background-normal"]);
        $('#menu_content, .ace_content').css('color', window.Asc.plugin.theme["text-normal"]);
        $('#context-menu-id .context-menu-options').css('background-color', window.Asc.plugin.theme["background-toolbar"]);
        $('.ace_layer.ace_gutter-layer.ace_folding-enabled').css('background', window.Asc.plugin.theme["background-toolbar"]);
        $('.ace_layer.ace_gutter-layer.ace_folding-enabled').css('color', window.Asc.plugin.theme["text-normal"]);
        $('#menu, .divFooter').css('border-color', window.Asc.plugin.theme["border-divider"]);
        $('.ace_scroller').css('border-left', 'solid 0.73px ' + window.Asc.plugin.theme["border-divider"]);
        $('.ace_cursor').css('color', window.Asc.plugin.theme["text-normal"]);
        $('#menu').css('background-color', window.Asc.plugin.theme["background-normal"]);
        $('#idRename').css('background-color', window.Asc.plugin.theme["background-toolbar"]);
        $('#idRename').css('border-color', window.Asc.plugin.theme["border-toolbar-button-hover"]);
        $('#idCert').css('background-color', window.Asc.plugin.theme["background-toolbar"]);
        $('#idCert').css('border-color', window.Asc.plugin.theme["border-toolbar-button-hover"]);
        $('#idSignWarning').css('background-color', window.Asc.plugin.theme["background-toolbar"]);
        $('#idSignWarning').css('border-color', window.Asc.plugin.theme["border-toolbar-button-hover"]);

        var rules = '.macros { color: ' + window.Asc.plugin.theme["text-normal"] + '; background-color: ' + window.Asc.plugin.theme['background-toolbar'] + '}\n';
        rules += '.macros:hover { background-color: ' + window.Asc.plugin.theme['highlight-button-hover'] + '}\n';
        rules += '.macrosSelected { background-color: ' + window.Asc.plugin.theme['highlight-button-pressed'] + '}\n';
        if (theme.type === 'dark')
            rules += '.ace-chrome .ace_marker-layer .ace_selected-word { background: rgb(250, 250, 255, 0.3) !important; border: 1px solid rgb(200, 200, 250); }'
        else
            rules += '.ace-chrome .ace_marker-layer .ace_selected-word { background: rgb(255, 255, 255); border: 1px solid rgb(200, 200, 250); }'
        var styleTheme = document.createElement('style');
        styleTheme.type = 'text/css';
        styleTheme.innerHTML = rules;
        document.getElementsByTagName('head')[0].appendChild(styleTheme);


        if (theme.type === 'dark')
            editor.setTheme("ace/theme/vs-dark")
        else
            editor.setTheme("ace/theme/vs-light")

    };

})(window, undefined);
