DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2653) THEN
		RETURN;
          END IF;
        BEGIN

       	 
INSERT INTO public."MessageSettings"
("Key", 
"Value", "Lang")
SELECT
'Notification.ShareFolder.Html', 
'<!DOCTYPE html
	PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head></head>

<body style="padding:0;Margin:0">
	<table cellpadding="0" cellspacing="0" border="0" width="100%">
		<tbody>
			<tr>
				<td align="center" bgcolor="#F8F8F8" width="100%">
					<table cellpadding="0" cellspacing="0" width="100%" border="0">
						<tbody>
							<tr>
								<td align="center">
									<table align="center" cellpadding="0" cellspacing="0" border="0"
										style="max-width:900px; min-width:320px; width:90%">
										<tbody>
											<tr>
												<td align="left">
													<table align="center" cellpadding="0" cellspacing="0" border="0" width="90%">
														<tbody>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table><img
																		src="data:image/png;base64,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"
																		border="0" style="display:block; max-width:250px; max-height: 35px; ">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
											<tr>
												<td align="left" bgcolor="#FFFFFF" style="border-radius:24px">
													<table align="center" cellpadding="0" cellspacing="0" border="0" width="90%">
														<tbody>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="30"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:22px; line-height:30px; color:#333333">
																		<strong>Вам предоставили доступ</strong>
																	</div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="10"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:16px; line-height:24px; color:#333333"
																		class="esd-text">Пользователь <strong>{{name}}</strong> предоставил
																		вам {{rigths}} к {{entityname}}:
																	</div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:16px; line-height:24px; color:#333333"
																		class="esd-text"><strong><a href="{{url}}">{{entityname}}</a></strong></div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="10"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																	<table cellpadding="0" cellspacing="0" border="0" width="200" style="width:200px">
																		<tbody>
																			<tr>
																				<td align="center" valign="middle" height="45"
																					style="background-color:#175cd3;border-radius:7px;height:45px"
																					bgcolor="#175CD3"><a href="{{url}}"
																						style="display:block;width:100%;font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; color:#ffffff; font-size:16px; line-height:45px; text-decoration:none; white-space:nowrap; margin:0!important; padding:0;">Открыть</a>
																				</td>
																			</tr>
																		</tbody>
																	</table>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="30"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
									<table cellpadding="0" cellspacing="0" border="0" width="100%">
										<tbody>
											<tr>
												<td height="40"></td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</tbody>
	</table>
</body>

</html>',''
	WHERE Not EXISTS (SELECT "Key" FROM public."MessageSettings" WHERE "Key"='Notification.ShareFolder.Html') ;


INSERT INTO public."MessageSettings"
("Key", 
"Value", "Lang")
select

'Notification.ShareFolder.Subject', 
'Вам предоставили доступ к папке',''
WHERE Not EXISTS (SELECT "Key" FROM public."MessageSettings" WHERE "Key"='Notification.ShareFolder.Subject') ;

INSERT INTO public."MessageSettings"
("Key", 
"Value", "Lang")
SELECT
'Notification.ShareDocument.Html', 
'<!DOCTYPE html
	PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head></head>

<body style="padding:0;Margin:0">
	<table cellpadding="0" cellspacing="0" border="0" width="100%">
		<tbody>
			<tr>
				<td align="center" bgcolor="#F8F8F8" width="100%">
					<table cellpadding="0" cellspacing="0" width="100%" border="0">
						<tbody>
							<tr>
								<td align="center">
									<table align="center" cellpadding="0" cellspacing="0" border="0"
										style="max-width:900px; min-width:320px; width:90%">
										<tbody>
											<tr>
												<td align="left">
													<table align="center" cellpadding="0" cellspacing="0" border="0" width="90%">
														<tbody>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table><img
																		src="data:image/png;base64,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"
																		border="0" style="display:block; max-width:250px; max-height: 35px; ">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
											<tr>
												<td align="left" bgcolor="#FFFFFF" style="border-radius:24px">
													<table align="center" cellpadding="0" cellspacing="0" border="0" width="90%">
														<tbody>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="30"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:22px; line-height:30px; color:#333333">
																		<strong>Вам предоставили доступ</strong>
																	</div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="10"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:16px; line-height:24px; color:#333333"
																		class="esd-text">Пользователь <strong>{{name}}</strong> предоставил
																		вам {{rigths}} к {{entityname}}:
																	</div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:16px; line-height:24px; color:#333333"
																		class="esd-text"><strong><a href="{{url}}">{{entityname}}</a></strong></div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="10"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																	<table cellpadding="0" cellspacing="0" border="0" width="200" style="width:200px">
																		<tbody>
																			<tr>
																				<td align="center" valign="middle" height="45"
																					style="background-color:#175cd3;border-radius:7px;height:45px"
																					bgcolor="#175CD3"><a href="{{url}}"
																						style="display:block;width:100%;font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; color:#ffffff; font-size:16px; line-height:45px; text-decoration:none; white-space:nowrap; margin:0!important; padding:0;">Открыть</a>
																				</td>
																			</tr>
																		</tbody>
																	</table>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="30"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
									<table cellpadding="0" cellspacing="0" border="0" width="100%">
										<tbody>
											<tr>
												<td height="40"></td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</tbody>
	</table>
</body>

</html>','' 
WHERE Not EXISTS (SELECT "Key" FROM public."MessageSettings" WHERE "Key"='Notification.ShareDocument.Html');


INSERT INTO public."MessageSettings"
("Key", 
"Value", "Lang")
SELECT 

'Notification.ShareDocument.Subject', 
'Вам предоставили доступ к документу','' WHERE Not EXISTS (SELECT "Key" FROM public."MessageSettings" WHERE "Key"='Notification.ShareDocument.Subject') ;



INSERT INTO public."MessageSettings"
("Key", 
"Value", "Lang")
SELECT
'Notification.ShareDefault.Html', 
'<!DOCTYPE html
	PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>

<head></head>

<body style="padding:0;Margin:0">
	<table cellpadding="0" cellspacing="0" border="0" width="100%">
		<tbody>
			<tr>
				<td align="center" bgcolor="#F8F8F8" width="100%">
					<table cellpadding="0" cellspacing="0" width="100%" border="0">
						<tbody>
							<tr>
								<td align="center">
									<table align="center" cellpadding="0" cellspacing="0" border="0"
										style="max-width:900px; min-width:320px; width:90%">
										<tbody>
											<tr>
												<td align="left">
													<table align="center" cellpadding="0" cellspacing="0" border="0" width="90%">
														<tbody>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table><img
																		src="data:image/png;base64,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"
																		border="0" style="display:block; max-width:250px; max-height: 35px; ">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
											<tr>
												<td align="left" bgcolor="#FFFFFF" style="border-radius:24px">
													<table align="center" cellpadding="0" cellspacing="0" border="0" width="90%">
														<tbody>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="30"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:22px; line-height:30px; color:#333333">
																		<strong>Вам предоставили доступ</strong>
																	</div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="10"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:16px; line-height:24px; color:#333333"
																		class="esd-text">Пользователь <strong>{{name}}</strong> предоставил
																		вам {{rigths}} к {{entityname}}:
																	</div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																	<div
																		style="font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; font-size:16px; line-height:24px; color:#333333"
																		class="esd-text"><strong><a href="{{url}}">{{entityname}}</a></strong></div>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="10"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
															<tr>
																<td align="left">
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="20"></td>
																			</tr>
																		</tbody>
																	</table>
																	<table cellpadding="0" cellspacing="0" border="0" width="200" style="width:200px">
																		<tbody>
																			<tr>
																				<td align="center" valign="middle" height="45"
																					style="background-color:#175cd3;border-radius:7px;height:45px"
																					bgcolor="#175CD3"><a href="{{url}}"
																						style="display:block;width:100%;font-family:-apple-system,''Segoe UI'',''Helvetica Neue'',Helvetica,Roboto,Arial,sans-serif; color:#ffffff; font-size:16px; line-height:45px; text-decoration:none; white-space:nowrap; margin:0!important; padding:0;">Открыть</a>
																				</td>
																			</tr>
																		</tbody>
																	</table>
																	<table cellpadding="0" cellspacing="0" border="0" width="100%">
																		<tbody>
																			<tr>
																				<td height="30"></td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
									<table cellpadding="0" cellspacing="0" border="0" width="100%">
										<tbody>
											<tr>
												<td height="40"></td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</tbody>
	</table>
</body>

</html>','' WHERE Not EXISTS (SELECT "Key" FROM public."MessageSettings" WHERE "Key"='Notification.ShareDefault.Html') ;

INSERT INTO public."MessageSettings"
("Key", 
"Value", "Lang")
SELECT
'Notification.ShareDefault.Subject', 
'Вам предоставили доступ {{type}}',''  WHERE Not EXISTS (SELECT "Key" FROM public."MessageSettings" WHERE "Key"='Notification.ShareDefault.Subject') ;

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Init notification MessageSettings error.';
        END;
    END;
$$

 
