DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-07-17-ProjectStatuses_UIndex';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4220) THEN
			RETURN;
		END IF;

		BEGIN

			CREATE UNIQUE INDEX IF NOT EXISTS "IDX_ProjectStatuses-EnitiyId-EnitiyType-Name"
    				ON public."ProjectStatuses" USING btree
    				("EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST, "Name" ASC NULLS LAST)
    				TABLESPACE pg_default;
			CREATE UNIQUE INDEX IF NOT EXISTS "IDX_ProjectTaskTypes-ProjectId-Name"
   				 ON public."ProjectTaskTypes" USING btree
    				("ProjectId" ASC NULLS LAST, "Name" ASC NULLS LAST)
    				TABLESPACE pg_default;
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-07-17-ProjectStatuses_UIndex: %', SQLERRM;
		END;
	END;
$$
