DO $$ 
	DECLARE _path character varying(256) = 'patch-2024_08_21_EventEmailInvite';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4230) THEN
			RETURN;
		END IF;

		BEGIN
CREATE TABLE IF NOT EXISTS public."EventEmailInvite" (
  "MessageId" bigint NOT NULL,
  "OwnerId" bigint NOT NULL, 
  "AttachmentId" bigint NOT NULL,
  "Uid" varchar(256) NOT NULL,
  "EventDetailId" bigint NULL,
  "Sequence" int2 NOT NULL,
  "Method" int2 NOT NULL,
  "State" int2,
  "InsertDate" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
  "CalDavBody" VARCHAR NULL,
  CONSTRAINT "UIDX_EventEmailInvite" UNIQUE ("MessageId")
);

CREATE INDEX  IF NOT EXISTS "IDX_EventEmailInvite_EventDetailId"
  ON public."EventEmailInvite" USING btree
  ("EventDetailId" ASC NULLS LAST)
  TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_EventEmailInvite_Uid"
  ON public."EventEmailInvite" USING btree
  ("Uid" ASC NULLS LAST)
  TABLESPACE pg_default;


			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-07-18-Licenses_UIndex: %', SQLERRM;
		END;
	END;
$$

