DO $$ 
	DECLARE _path character varying(256) = 'patch-2025-03-01-EventMailLocalization.sql';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14721) THEN
			RETURN;
		END IF;

		BEGIN

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Subject','Обновление события','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Subject','Event update','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Subject','Приглашение на событие','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Subject','Invitation to the event','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Body','Событие {0} было обновлено.','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Body','Event {0} has been updated.','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Body','Пользователь {0} пригласил Вас на событие {1}.','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Body','User {0} invited you to the event {1}.','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Subject','Отмена события','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Subject','Event cancel','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Body','Пользователь {0} отменил событие {1}.','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Body','User {0} cancelled event {1}.','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Subject','Приглашение на \"{0}\" принято','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Subject','Invitation to \"{0}\" accepted','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Body','Пользователь {0} подтвердил участие в событии \"{1}\".\nНачало события: {2}','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Body','User {0} has confirmed participation in the \"{1}\" event.\nThe beginning of the event: {2}','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Subject','Приглашение на \"{0}\" отклонено','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Subject','Invitation to \"{0}\" declined','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Body','Пользователь {0} отказался от участия в событии \"{1}\".\nНачало события: {2}','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Body','User {0} declined to participate in the \"{1}\" event.\nThe beginning of the event: {2}','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Subject','Участие в \"{0}\" под вопросом','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Subject','Participation in \"{0}\" is questionable','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Body','Пользователь {0} ответил \"может быть\" на приглашение в событие \"{1}\".\nНачало события: {2}','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Body','User {0} replied \"maybe\" to the invitation to the event \"{1}\".\nThe beginning of the event: {2}','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025-03-01-EventMailLocalization: %', SQLERRM;
		END;
	END;
$$