DO $$ 
	DECLARE _path character varying(256) = 'patch-2025-03-04-UserActionsLocalization.sql';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14721) THEN
			RETURN;
		END IF;

		BEGIN
			DELETE FROM public."MessageSettings" WHERE ("Key" = 'UserActionTypes.Localization' OR "Key" = 'UserActionMessages.Localization') AND "Lang" = 'ru' ;
		
			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('UserActionTypes.Localization','{
				"Types": {
					"UserLogin": "Успешная авторизация",
					"AuthError": "Неудачная попытка",
					"Logout": "Выход из системы",
					"AddDocument": "Создание документа",
					"DeleteDocument": "Удаление документа из папки",
					"DeleteTrashDocument": "Удаление документа из корзины",
					"DeleteGlobalTrashDocument": "Удаление документа из глобальной корзины",
					"DeleteCalendar": "Удаление календаря",
					"AddFavoriteContact": "Добавление в избранное контакта",
					"AddFavoriteDocument": "Добавление в избранное документа",
					"AddLink": "Создание ссылки",
					"AddExternalLink": "Создание внешней ссылки",
					"DownloadDocument": "Скачивание документа",
					"UploadDocument": "Загрузка документа",
					"DownloadDocumentByLink": "Скачивание документа по ссылке",
					"DocumentOpen": "Открытие документа",
					"DocumentOpenUid": "Открытие документа по внешней ссылке",
					"DocumentEdit": "Редактирование документа",
					"EntityShareEvent": "Предоставление доступа к событию",
					"EntityShareCalendar": "Предоставление доступа к календарю",
					"EntityShareProjects": "Предоставление доступа к проекту",
					"DeleteDirectory": "Удаление папки",
					"DeleteEvent": "Удаление события",
					"GetDocuments": "Получение списка документов",
					"RestoreDirectory": "Восстановление папки",
					"MoveDocument": "Перемещение документа",
					"DeleteUser": "Удаление пользователя",
					"DeleteUserWithTransfer": "Удаление пользователя с переносом документов",
					"ChangeTokenDuration": "Изменение времени существования токена",
					"PasswordEnterCount": "Изменение ограничения попыток ввода пароля",
					"UserIpWhiteList": "Изменение IP-безопасности пользователей",
					"AdminIpWhiteList": "Изменение IP-безопасности администрирования",
					"ChangeLdapSettings": "Изменения метода аутентификации"
				}
			}','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('UserActionTypes.Localization','{
				"Types": {
					"UserLogin": "Successful authorization",
					"AuthError": "Failed attempt",
					"Logout": "Log out of the system",
					"AddDocument": "Creating a document",
					"DeleteDocument": "Deleting a document from a folder",
					"DeleteTrashDocument": "Deleting a document from the trash",
					"DeleteGlobalTrashDocument": "Deleting a document from the global trash",
					"DeleteCalendar": "Deleting a calendar",
					"AddFavoriteContact": "Adding a contact to favorites",
					"AddFavoriteDocument": "Adding a document to favorites",
					"AddLink": "Creating a link",
					"AddExternalLink": "Creating an external link",
					"DownloadDocument": "Downloading a document",
					"UploadDocument": "Uploading a document",
					"DownloadDocumentByLink": "Downloading a document from a link",
					"DocumentOpen": "Opening a document",
					"DocumentOpenUid": "Opening a document via an external link",
					"DocumentEdit": "Document Editing",
					"EntityShareEvent": "Providing access to the event",
					"EntityShareCalendar": "Providing access to the calendar",
					"EntityShareProjects": "Providing access to the project",
					"DeleteDirectory": "Deleting a folder",
					"DeleteEvent": "Deleting an event",
					"GetDocuments": "Getting a list of documents",
					"RestoreDirectory": "Folder Recovery",
					"MoveDocument": "Moving a document",
					"DeleteUser": "Deleting a user",
					"DeleteUserWithTransfer": "Deleting a user while transferring documents",
					"ChangeTokenDuration": "Changing the token lifetime",
					"PasswordEnterCount": "Changing for limiting password entry attempts",
					"UserIpWhiteList": "Changing the IP security of users",
					"AdminIpWhiteList": "Changing the IP security of administration",
					"ChangeLdapSettings": "Changing the authentication method"
				}
			}','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('UserActionMessages.Localization','{
				"Types": {
					"UserLogin": "Успешная авторизация через Api",
					"AuthError": "Неудачная попытка авторизации через Api",
					"Logout": "Выход из системы",
					"AddDocument": "Создание документа {0} в папке {1}",
					"DeleteDocument": "Удаление документа {0} из папки {1}",
					"DeleteTrashDocument": "Удаление документа {0} из корзины",
					"DeleteGlobalTrashDocument": "Удаление документа {0} из глобальной корзины",
					"DeleteCalendar": "Удаление календаря {0}",
					"AddFavoriteContact": "Добавление в изранное контакта {0}",
					"AddFavoriteDocument": "Добавление в изранное документа {0}",
					"AddLink": "Создание ссылки на {0} {1}",
					"AddExternalLink": "Создание внешней ссылки на {0} {1}",
					"DownloadDocument": "Скачивание документа {0}",
					"UploadDocument": "Загрузка документа {0} в папку {1}",
					"DownloadDocumentByLink": "Скачивание документа {0} по ссылке",
					"DocumentOpen": "Открытие документа {0} по внутренней ссылке",
					"DocumentOpenUid": "Открытие документа {0} по внешней ссылке",
					"DocumentEdit": "Редактирование документа {0}",
					"EntityShareEvent": "Предоставлен доступа к событиям {0} для {1}",
					"EntityShareCalendar": "Предоставлен доступа к календарям {0} для {1}",
					"EntityShareProjects": "Предоставлен доступа к проектам {0} для {1}",
					"DeleteDirectory": "Удаление папки {0}",
					"DeleteEvent": "Удаление события {0}",
					"GetDocuments": "Получение списка документов папки {0}",
					"RestoreDirectory": "Восстановление папки {0} в папку {1}",
					"MoveDocument": "Перемещение документа {0} из папки {1} в папку {2}",
					"DeleteUser": "Удаление пользователя {0}",
					"DeleteUserWithTransfer": "Удаление пользователя {0} с переносом документов пользователю {1}",
					"ChangeTokenDuration": "Изменение настроек времени существования токена",
					"PasswordEnterCount": "Изменение настроек ограничения попыток ввода пароля",
					"UserIpWhiteList": "Изменение настроек IP-безопасности пользователей",
					"AdminIpWhiteList": "Изменение настроек IP-безопасности администрирования",
					"ChangeLdapSettings": "Изменение настроек метода аутентификации"
				}
			}','')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('UserActionMessages.Localization','{
				"Types": {
					"UserLogin": "Successful authorization via Api",
					"AuthError": "Failed authorization attempt via Api",
					"Logout": "Log out of the system",
					"AddDocument": "Creating a document {0} in folder {1}",
					"DeleteDocument": "Deleting document {0} from folder {1}",
					"DeleteTrashDocument": "Deleting document {0} from the trash",
					"DeleteGlobalTrashDocument": "Deleting document {0} from the global trash",
					"DeleteCalendar": "Calendar deletion {0}",
					"AddFavoriteContact": "Adding a contact to the wounded {0}",
					"AddFavoriteDocument": "Adding a damaged document {0}",
					"AddLink": "Creating a link to {0} {1}",
					"AddExternalLink": "Creating an external link to {0} {1}",
					"DownloadDocument": "Downloading a document {0}",
					"UploadDocument": "Uploading a document {0} to folder {1}",
					"DownloadDocumentByLink": "Downloading the document {0} from the link",
					"DocumentOpen": "Opening a document {0} via an internal link",
					"DocumentOpenUid": "Opening a document {0} via an external link",
					"DocumentEdit": "Document editing {0}",
					"EntityShareEvent": "Granted access to events {0} for {1}",
					"EntityShareCalendar": "Granted access to calendars {0} for {1}",
					"EntityShareProjects": "Granted access to projects {0} for {1}",
					"DeleteDirectory": "Deleting a folder {0}",
					"DeleteEvent": "Deleting an event {0}",
					"GetDocuments": "Getting a list of documents in folder {0}",
					"RestoreDirectory": "Restoring folder {0} to folder {1}",
					"MoveDocument": "Moving a document {0} from folder {1} to folder {2}",
					"DeleteUser": "Deleting a user {0}",
					"DeleteUserWithTransfer": "Deleting user {0} with transferring documents to user {1}",
					"ChangeTokenDuration": "Changing the token lifetime settings",
					"PasswordEnterCount": "Changing the settings for limiting password entry attempts",
					"UserIpWhiteList": "Changing User IP Security settings",
					"AdminIpWhiteList": "Changing the administration IP security settings",
					"ChangeLdapSettings": "Changing the authentication method settings"
				}
			}','en')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025-03-04-UserActionsLocalization: %', SQLERRM;
		END;
	END;
$$