DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_04_28-InitOAuthApplications.sql';

	BEGIN

		BEGIN
		
			INSERT INTO public."Applications"("Key", "Name")
			SELECT 'pages',  'АРМ Страницы' WHERE NOT EXISTS(SELECT "Key" FROM public."Applications" WHERE "Key"='pages');

			INSERT INTO public."Applications"("Key", "Name")
			SELECT 'forms',  'АРМ Формы' WHERE NOT EXISTS(SELECT "Key" FROM public."Applications" WHERE "Key"='forms');

			INSERT INTO public."AuthClients"("Name", "ClientId", "ClientSecret", "RedirectUrl", "ApplicationKey")
			VALUES('Формы', :forms_client_id, :forms_secret, '', 'forms')
			ON CONFLICT ("ApplicationKey") DO NOTHING;

			INSERT INTO public."AuthClients"("Name", "ClientId", "ClientSecret", "RedirectUrl", "ApplicationKey")
			VALUES('Страницы', :pages_client_id, :pages_secret, '', 'pages')
			ON CONFLICT ("ApplicationKey") DO NOTHING;
			
			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('pagesUrl' ,:pages_url,'')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('formsUrl' ,:forms_url,'')
			ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_04_28-InitOAuthApplications: %', SQLERRM;
		END;
	END;
$$
