DO $$ 
	DECLARE _path character varying(256) = 'patch-2025-03-14-EventDetails-v2';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14897) THEN
			RETURN;
		END IF;

		BEGIN
            ALTER TABLE public."EventDetails" ADD "StartDate" TIMESTAMP not NULL DEFAULT '1900-01-01 00:00:00';

			update public."EventDetails" d set "StartDate" = coalesce((select "Date" from public."Events" where "DetailId"=d."Id" limit 1), d."StartDate") where "Type"=0;
			update public."EventDetails" d set "StartDate" = COALESCE((select "StartDate" from public."EventRecurring" where "Id"=d."RecurringId"), d."StartDate") where "Type"!=0;
			
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025-03-14-EventDetails: %', SQLERRM;
		END;
	END;
$$