DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_09-UserActionsCustomerId';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15110) THEN
			RETURN;
		END IF;

		BEGIN

			ALTER TABLE public."UserActions" ADD "CustomerId" int NULL;

			CREATE INDEX "UserActions_IDX_CustomerId"
				ON public."UserActions" USING btree
					("CustomerId" ASC NULLS LAST)
				TABLESPACE pg_default;

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
		EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE 'patch-2025_06_09-UserActionsCustomerId: %', SQLERRM;


		END;
	END;
$$