DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_09-ProjectSprints';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15456) THEN
            RETURN;
        END IF;

        BEGIN

	CREATE INDEX IF NOT EXISTS "IDX_ProjectSprints-ProjectId-State-AuthorId"
    ON public."ProjectSprints" USING btree
    ("ProjectId" ASC NULLS LAST, "State" ASC NULLS LAST, "AuthorId" ASC NULLS LAST)
    TABLESPACE pg_default;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;