DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_23-ProjectTaskActivities';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15529) THEN
            RETURN;
        END IF;

        BEGIN
	
	drop INDEX IF EXISTS "IDX_ProjectTaskTypes-ProjectId-Name";

	ALTER TABLE public."ProjectTaskActivities" ADD "Updated" timestamp without time zone;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;