DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_24-ProjectSettings';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15530) THEN
            RETURN;
        END IF;

        BEGIN

	UPDATE public."ProjectSettings" SET "FeaturesJson"='["Attributes"]'
		WHERE "FeaturesJson"='[]' AND EXISTS (SELECT pal."ProjectId" 
		FROM  public."ProjectAttributeLinks" pal WHERE pal."ProjectId"=public."ProjectSettings"."ProjectId" );
	
	INSERT INTO public."ProjectSettings" ("FeaturesJson","ProjectId") 
		SELECT DISTINCT '["Attributes"]', pal."ProjectId" 
		FROM  public."ProjectAttributeLinks" pal 
		WHERE NOT EXISTS (SELECT * FROM public."ProjectSettings" ps where ps."ProjectId"= pal."ProjectId");

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;