﻿DO $$
    DECLARE
        _path character varying(256) := 'patch-2025_12_12-GroupAddUid';
    BEGIN
        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Path" = _path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Build" >= 15813) THEN
            RETURN;
        END IF;

        BEGIN
 
            ALTER TABLE public."Groups" ADD COLUMN IF NOT EXISTS "Uid" character varying(256);

	    CREATE INDEX IF NOT EXISTS "IDX_Groups-Uid-OwnerId"
    		ON public."Groups" USING btree
    		("Uid" ASC NULLS LAST,"OwnerId" ASC NULLS LAST)
    		TABLESPACE pg_default;

	 	update public."Groups" SET "Uid"='G-'::text || "Id"::text;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

        EXCEPTION
            WHEN OTHERS THEN
                RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;

    END;
$$;