CREATE TABLE public."Tasks" (
    "Id" bigserial PRIMARY KEY,
    "UserId" bigint NOT NULL,
    "OwnerId" bigint NOT NULL,
    "ParentId" bigint NULL,
    "Status" integer DEFAULT 0 NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL,
    "Json" text,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Percent" numeric
);

CREATE INDEX "IDX_Tasks_OwnerId-UserId-Type-Status"
    ON public."Tasks" USING btree
    ("OwnerId" ASC NULLS LAST, "UserId" ASC NULLS LAST, "Status" ASC NULLS LAST, "Type" ASC NULLS LAST)
    TABLESPACE pg_default; 