CREATE TABLE public."DirectoryHierarchies" (
    "DirectoryId" bigint NOT NULL,
    "ParentId" bigint NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    PRIMARY KEY ("DirectoryId", "ParentId")
);

CREATE INDEX "IDX_DirectoryHierarchies_ParentId"
    ON public."DirectoryHierarchies" USING btree
    ("ParentId" ASC NULLS LAST)
    TABLESPACE pg_default;  