CREATE TABLE public."EmailAddressBook"
(
	"Id" bigserial,
	"Hash" character varying(64) NOT NULL,
	"Address" character varying(1024) NULL, 
	"OwnerId" BIGINT NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
         CONSTRAINT "PK_EmailAddressBook" PRIMARY KEY("Hash")

);

CREATE INDEX "IDX_EmailAddressBook_OwnerId"
    ON public."EmailAddressBook" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 