CREATE TABLE public."EmailFolders"
(
	"Id" bigserial  PRIMARY KEY,
	"Hash" character varying(64) NOT NULL,
	"Name" character varying(1024) NULL,
	"ParentId" BIGINT NULL,
	"Type" INT NOT NULL,
	"Status" INT NOT NULL,
	"ExternalId" character varying(64) NULL,
	"OwnerId" BIGINT NOT NULL,
	"UserEmailId" BIGINT NOT NULL,
	"State" INT DEFAULT 0 NOT NULL,
	"UidValidity" bigint default 0 not null,
	"UidNext" bigint default 0 not null,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
	"Total" integer NULL,
	"Unread" integer NULL
);

CREATE INDEX "IDX_EmailFolders_Hash"
    ON public."EmailFolders" USING btree
    ("Hash" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailFolders_OwnerId"
    ON public."EmailFolders" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailFolders_ParentId"
    ON public."EmailFolders" USING btree
    ("ParentId" ASC NULLS LAST)
    TABLESPACE pg_default; 