CREATE TABLE public."EventDeleted" (
    "Id" bigserial PRIMARY KEY,
    "CalendarId" bigint NOT NULL,
    "Uid" character varying(256),
    "LastModificationDate" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

 

CREATE INDEX "IDX_EventDeleted_CalendarId_LastModificationDate"
    ON public."EventDeleted" USING btree
    ("CalendarId" ASC NULLS LAST,"LastModificationDate" ASC NULLS LAST)
    TABLESPACE pg_default; 

