-- Table: public.ProjectLabels

-- DROP TABLE IF EXISTS public."ProjectLabels";

CREATE TABLE IF NOT EXISTS public."ProjectLabels"
(
    "Id" bigserial NOT NULL ,
    "Name" character varying(500),
    "Color" character varying(64)  NOT NULL,
    "ProjectId" bigint NOT NULL,
    "OwnerId" bigint NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "Order" int4 NOT NULL DEFAULT 0,
    CONSTRAINT "ProjectLabels_pkey" PRIMARY KEY ("Id")
);

CREATE INDEX IF NOT EXISTS "IDX_ProjectLabels-OwnerId"
    ON public."ProjectLabels" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;
-- Index: IDX_ProjectLabels-ProjectId

-- DROP INDEX IF EXISTS public."IDX_ProjectLabels-ProjectId";

CREATE INDEX IF NOT EXISTS "IDX_ProjectLabels-ProjectId"
    ON public."ProjectLabels" USING btree
    ("ProjectId" ASC NULLS LAST)
    TABLESPACE pg_default;