CREATE TABLE IF NOT EXISTS public."ProjectSprints"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(500) NOT NULL,
    "Description" character varying(3000),
    "ProjectId" bigint NOT NULL,
    "AuthorId" bigint NOT NULL,
    "Status" integer NOT NULL DEFAULT 0,
    "State" integer DEFAULT 1,
    "Type" integer NOT NULL DEFAULT 0,
    "Flags" integer NOT NULL DEFAULT 0,
    "Color" character varying(10),
    "StartDate" timestamp without time zone,
    "EndDate" timestamp without time zone,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "Updated" timestamp without time zone,
    "Order" bigint DEFAULT 0,
    "DeleteUserId" bigint NULL,
    CONSTRAINT "ProjectSprints_pkey" PRIMARY KEY ("Id")
);
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectSprints-ProjectId-AuthorId"
    ON public."ProjectSprints" USING btree
    ("ProjectId" ASC NULLS LAST, "AuthorId" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_ProjectSprints-ProjectId-State-AuthorId"
    ON public."ProjectSprints" USING btree
    ("ProjectId" ASC NULLS LAST, "State" ASC NULLS LAST, "AuthorId" ASC NULLS LAST)
    TABLESPACE pg_default;