﻿CREATE TABLE IF NOT EXISTS public."ProjectTaskUserPerformer" ( 
	"UserId" bigint NOT NULL,
	"TaskId" bigint NOT NULL,
	"ProjectId" bigint NOT NULL,
	"Timestamp" timestamp DEFAULT timezone('utc'::text, now()) NOT NULL,
	CONSTRAINT "ProjectTaskUserPerformer_pkey" PRIMARY KEY ("UserId", "TaskId")
);

CREATE INDEX IF NOT EXISTS  "IDX_ProjectTaskUserPerformer_UserId-TaskId" ON public."ProjectTaskUserPerformer" USING btree ("UserId", "TaskId");

CREATE INDEX IF NOT EXISTS  "IDX_ProjectTaskUserPerformer_ProjectId" ON public."ProjectTaskUserPerformer" USING btree ("ProjectId");
