#!/bin/bash

[ $(id -u) -ne 0 ] && { echo "Root privileges required"; exit 1; }

CONF_DIR="/etc/r7-office/documentserver"
DIR="/var/www/r7-office/documentserver"

LOCAL_CONFIG="${CONF_DIR}/local.json"
DEFAULT_CONFIG="${CONF_DIR}/default.json"
Configs=("$LOCAL_CONFIG" "$DEFAULT_CONFIG")

JSON_BIN="$DIR/npm/json"

for i in "${!Configs[@]}";
do
	if [ -f ${Configs[$i]} ]; then
		JSON="$JSON_BIN -f ${Configs[$i]}"
		JWT_ENABLED=$($JSON "services.CoAuthoring.token.enable.request.inbox")	
		JWT_SECRET=$($JSON "services.CoAuthoring.secret.inbox.string")
		JWT_HEADER=$($JSON "services.CoAuthoring.token.inbox.header")
		if [ -n "$JWT_ENABLED" ]; then	
			echo "Your JWT settings:"
			echo "JWT enabled -  $JWT_ENABLED"
			if [ $JWT_ENABLED = "true" ]; then
				echo "JWT secret  -  $JWT_SECRET"
				echo "JWT header  -  $JWT_HEADER"		
			fi
			break
		fi
	fi
done
